/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import java.util.ArrayList;
import java.util.List;

public class SubsetContinuousVariablesWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public SubsetContinuousVariablesWrapper(DataWrapper data) {
        if (data == null) {
            throw new NullPointerException("The givan data must not be null");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The given dataset must be tabular");
        }
        this.setDataModel(SubsetContinuousVariablesWrapper.createModel((DataSet)model));
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Parent data restricted to continuous variables only.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new SubsetContinuousVariablesWrapper(new DataWrapper(DataUtils.continuousSerializableInstance()));
    }

    private static DataModel createModel(DataSet data) {
        List<Node> variables = data.getVariables();
        int n = 0;
        for (Node variable : variables) {
            if (!(variable instanceof ContinuousVariable)) continue;
            ++n;
        }
        if (n == 0) {
            return new ColtDataSet(0, new ArrayList<Node>());
        }
        int[] indices = new int[n];
        int m = 0;
        for (int i = 0; i < variables.size(); ++i) {
            if (!(variables.get(i) instanceof ContinuousVariable)) continue;
            indices[m++] = i;
        }
        return data.subsetColumns(indices);
    }
}

