/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import java.util.ArrayList;
import java.util.List;

public class SubsetDiscreteVariablesWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public SubsetDiscreteVariablesWrapper(DataWrapper data) {
        if (data == null) {
            throw new NullPointerException("The givan data must not be null");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The given dataset must be tabular");
        }
        this.setDataModel(SubsetDiscreteVariablesWrapper.createModel((DataSet)model));
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Parent data restricted to discrete variables only.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new SubsetDiscreteVariablesWrapper(new DataWrapper(DataUtils.continuousSerializableInstance()));
    }

    private static DataModel createModel(DataSet data) {
        List<Node> variables = data.getVariables();
        int n = 0;
        for (Node variable : variables) {
            if (!(variable instanceof DiscreteVariable)) continue;
            ++n;
        }
        if (n == 0) {
            return new ColtDataSet(0, new ArrayList<Node>());
        }
        int[] indices = new int[n];
        int m = 0;
        for (int i = 0; i < variables.size(); ++i) {
            if (!(variables.get(i) instanceof DiscreteVariable)) continue;
            indices[m++] = i;
        }
        return data.subsetColumns(indices);
    }
}

