/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetradapp.util.IntTextField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class IntSpinner
extends JSpinner {
    private IntTextField editor;
    private Filter filter;
    private Integer min;
    private Integer max;

    public IntSpinner(Integer value, Integer step, Integer size) {
        super(new SpinnerNumberModel(value, null, null, step));
        this.editor = new IntTextField(value, (int)size);
        this.setPreferredSize(IntSpinner.increment(this.editor.getPreferredSize(), 2));
        this.setMaximumSize(IntSpinner.increment(this.editor.getMaximumSize(), 2));
        this.setMinimumSize(IntSpinner.increment(this.editor.getMinimumSize(), 2));
        this.setSize(IntSpinner.increment(this.editor.getSize(), 2));
        this.editor.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (IntSpinner.this.min != null && value < IntSpinner.this.min) {
                    value = IntSpinner.this.min;
                } else if (IntSpinner.this.max != null && IntSpinner.this.max < value) {
                    value = IntSpinner.this.max;
                }
                return value;
            }
        });
        this.editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntTextField field = (IntTextField)e.getSource();
                String text = field.getText();
                try {
                    int value = Integer.parseInt(text);
                    field.setValue(value);
                    value = field.getValue();
                    if (!IntSpinner.this.getValue().equals(value)) {
                        IntSpinner.this.setValue(value);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        });
        this.setEditor(this.editor);
    }

    public void setMin(Integer min) {
        if (this.min != min) {
            this.min = min;
            SpinnerNumberModel model = (SpinnerNumberModel)this.getModel();
            if (min == null) {
                model.setMinimum(null);
            } else {
                model.setMinimum(min);
            }
            this.editor.setValue(this.editor.getValue());
        }
    }

    public void setMax(Integer max) {
        if (this.max != max) {
            this.max = max;
            SpinnerNumberModel model = (SpinnerNumberModel)this.getModel();
            if (max == null) {
                model.setMaximum(null);
            } else {
                model.setMaximum(max);
            }
            this.editor.setValue(this.editor.getValue());
        }
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int value = this.filter((Integer)object);
        if (!this.getValue().equals(value)) {
            super.setValue(value);
            this.editor.setUnfilteredValue(value);
        }
    }

    private static Dimension increment(Dimension dim, int increment) {
        return new Dimension(dim.width + increment, dim.height + increment);
    }

    private int filter(int value) {
        if (this.filter == null) {
            return value;
        }
        if (this.getValue().equals(value)) {
            return value;
        }
        return this.filter.filter((Integer)this.getValue(), value);
    }

    public static interface Filter {
        public int filter(int var1, int var2);
    }
}

