/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public final class IntTextField
extends JTextField {
    private int value;
    private Filter filter;

    public IntTextField(int value, int size) {
        super(size);
        this.setValue(value);
        this.setText(Integer.toString(value));
        this.setHorizontalAlignment(4);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int n = Integer.parseInt(e.getActionCommand());
                    IntTextField.this.setValue(n);
                }
                catch (NumberFormatException e1) {
                    IntTextField.this.setText(Integer.toString(IntTextField.this.getValue()));
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                IntTextField source = (IntTextField)e.getSource();
                source.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    int n = Integer.parseInt(IntTextField.this.getText());
                    IntTextField.this.setValue(n);
                }
                catch (NumberFormatException e1) {
                    IntTextField.this.setText(Integer.toString(IntTextField.this.getValue()));
                }
            }
        });
    }

    public void setUnfilteredValue(int value) {
        this.setText(String.valueOf(value));
    }

    public void setValue(int value) {
        if (value == this.value) {
            return;
        }
        int newValue = this.filter(value, this.value);
        if (newValue == this.value) {
            this.setText(Integer.toString(this.value));
        } else {
            this.value = newValue;
            this.setText(Integer.toString(this.value));
            this.firePropertyChange("newValue", null, (Object)this.value);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private int filter(int value, int oldValue) {
        if (this.filter == null) {
            return value;
        }
        return this.filter.filter(value, oldValue);
    }

    public static interface Filter {
        public int filter(int var1, int var2);
    }
}

