/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class TetradButtonUI
extends BasicButtonUI {
    private static final TetradButtonUI TETRAD_BUTTON_UI = new TetradButtonUI();

    public static ButtonUI createUI() {
        return TETRAD_BUTTON_UI;
    }

    public static ComponentUI createUI(JComponent c) {
        return TETRAD_BUTTON_UI;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return super.createButtonListener(b);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
    }
}

