/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.TetradSerializableExcluded;
import edu.cmu.tetradapp.workbench.DisplayComp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class DisplayNode
extends JComponent
implements Node,
TetradSerializableExcluded {
    private Node modelNode;
    private boolean selected = false;
    private DisplayComp displayComp;

    public DisplayNode() {
        this.setName("");
    }

    public final void setModelNode(Node modelNode) {
        if (modelNode == null) {
            throw new NullPointerException();
        }
        this.modelNode = modelNode;
        this.setName(modelNode.getName());
        modelNode.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("name".equals(evt.getPropertyName())) {
                    DisplayNode.this.setName((String)evt.getNewValue());
                }
            }
        });
    }

    public final Node getModelNode() {
        return this.modelNode;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        super.setName(name);
        if (this.displayComp != null) {
            this.displayComp.setName(name);
        }
        this.repaint();
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.firePropertyChange("selected", oldSelected, selected);
        if (this.displayComp != null) {
            this.displayComp.setSelected(selected);
        }
        this.repaint();
    }

    public final boolean isSelected() {
        return this.selected;
    }

    @Override
    public final void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.getModelNode() != null) {
            this.getModelNode().setCenter(x + this.getWidth() / 2, y + this.getHeight() / 2);
        }
    }

    public final Point getCenterPoint() {
        Rectangle bounds = this.getBounds();
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        return new Point(centerX, centerY);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.getDisplayComp() != null) {
            return this.getDisplayComp().contains(x, y);
        }
        return super.contains(x, y);
    }

    public void doDoubleClickAction() {
    }

    public void doDoubleClickAction(Graph graph) {
    }

    public DisplayComp getDisplayComp() {
        return this.displayComp;
    }

    public void setDisplayComp(DisplayComp displayComp) {
        this.displayComp = displayComp;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)((JComponent)((Object)displayComp)), "Center");
    }

    @Override
    public NodeType getNodeType() {
        return null;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
    }

    @Override
    public int getCenterX() {
        return 0;
    }

    @Override
    public void setCenterX(int centerX) {
    }

    @Override
    public int getCenterY() {
        return 0;
    }

    @Override
    public void setCenterY(int centerY) {
    }

    @Override
    public void setCenter(int centerX, int centerY) {
    }
}

