/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.ErrorDisplayComp;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GraphNodeError
extends DisplayNode {
    public GraphNodeError(Node modelNode) {
        this.setModelNode(modelNode);
        if (modelNode.getNodeType() != NodeType.ERROR) {
            throw new IllegalArgumentException("GraphNodeError requires a GraphNode of type NodeType.ERROR.");
        }
        this.setDisplayComp(new ErrorDisplayComp(modelNode.getName()));
    }

    @Override
    public void doDoubleClickAction(Graph graph) {
        List<Node> nodes = graph.getNodes();
        String newName = this.chooseNewVariableName(nodes);
        if (super.getModelNode() != null) {
            super.getModelNode().setName(newName);
        }
    }

    @Override
    public void doDoubleClickAction() {
        this.doDoubleClickAction(null);
    }

    private String chooseNewVariableName(List<Node> nodes) {
        String newName;
        block0: while (true) {
            JTextField nameField = new JTextField(8);
            nameField.addFocusListener(new FocusAdapter(){
                boolean alreadyLostFocus = false;

                @Override
                public void focusLost(FocusEvent e) {
                    if (this.alreadyLostFocus) {
                        return;
                    }
                    JTextField field = (JTextField)e.getSource();
                    field.grabFocus();
                    this.alreadyLostFocus = true;
                }
            });
            nameField.setText(this.getName());
            nameField.setCaretPosition(0);
            nameField.moveCaretPosition(this.getName().length());
            JPanel message = new JPanel();
            message.add(new JLabel("Name:"));
            message.add(nameField);
            JOptionPane pane = new JOptionPane(message, -1, 2);
            JDialog dialog = pane.createDialog(this, "Node Properties");
            dialog.pack();
            dialog.setVisible(true);
            newName = nameField.getText();
            if (!NamingProtocol.isLegalName(newName)) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), NamingProtocol.getProtocolDescription());
                continue;
            }
            if (nodes == null) break;
            for (Node node : nodes) {
                if (!newName.equals(((Object)node).toString()) || newName.equals(super.getModelNode().getName())) continue;
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "The name '" + newName + "' is already being used." + "\nPlease choose another name.");
                continue block0;
            }
            break;
        }
        return newName;
    }
}

