/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jdepend.framework.JavaClass;

public class JavaPackage {
    private String _name;
    private HashSet _classes;
    private List _afferents;
    private List _efferents;

    public JavaPackage(String string) {
        this._name = string;
        this._classes = new HashSet();
        this._afferents = new ArrayList();
        this._efferents = new ArrayList();
    }

    public String getName() {
        return this._name;
    }

    public boolean containsCycle() {
        return this.collectCycle(new ArrayList());
    }

    public boolean collectCycle(List list) {
        if (list.contains(this)) {
            list.add(this);
            return true;
        }
        list.add(this);
        Iterator iterator = this.getEfferents().iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage = (JavaPackage)iterator.next();
            if (!javaPackage.collectCycle(list)) continue;
            return true;
        }
        list.remove(this);
        return false;
    }

    public void addClass(JavaClass javaClass) {
        this._classes.add(javaClass);
    }

    public Collection getClasses() {
        return this._classes;
    }

    public int getClassCount() {
        return this._classes.size();
    }

    public int getAbstractClassCount() {
        int n = 0;
        Iterator iterator = this._classes.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (!javaClass.isAbstract()) continue;
            ++n;
        }
        return n;
    }

    public int getConcreteClassCount() {
        int n = 0;
        Iterator iterator = this._classes.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (javaClass.isAbstract()) continue;
            ++n;
        }
        return n;
    }

    public void dependsUpon(JavaPackage javaPackage) {
        this.addEfferent(javaPackage);
        javaPackage.addAfferent(this);
    }

    public void addAfferent(JavaPackage javaPackage) {
        if (!javaPackage.getName().equals(this.getName()) && !this._afferents.contains(javaPackage)) {
            this._afferents.add(javaPackage);
        }
    }

    public Collection getAfferents() {
        return this._afferents;
    }

    public void setAfferents(Collection collection) {
        this._afferents = new ArrayList(collection);
    }

    public void addEfferent(JavaPackage javaPackage) {
        if (!javaPackage.getName().equals(this.getName()) && !this._efferents.contains(javaPackage)) {
            this._efferents.add(javaPackage);
        }
    }

    public Collection getEfferents() {
        return this._efferents;
    }

    public void setEfferents(Collection collection) {
        this._efferents = new ArrayList(collection);
    }

    public int afferentCoupling() {
        return this._afferents.size();
    }

    public int efferentCoupling() {
        return this._efferents.size();
    }

    public float instability() {
        float f = (float)this.efferentCoupling() + (float)this.afferentCoupling();
        if (f > 0.0f) {
            return (float)this.efferentCoupling() / f;
        }
        return 0.0f;
    }

    public float abstractness() {
        if (this.getClassCount() > 0) {
            return (float)this.getAbstractClassCount() / (float)this.getClassCount();
        }
        return 0.0f;
    }

    public float distance() {
        return Math.abs(this.abstractness() + this.instability() - 1.0f);
    }

    public boolean equals(Object object) {
        if (object instanceof JavaPackage) {
            JavaPackage javaPackage = (JavaPackage)object;
            return javaPackage.getName().equals(this.getName());
        }
        return false;
    }

    public boolean equalsDependencies(Object object) {
        return this.equalsAfferents(object) && this.equalsEfferents(object);
    }

    public boolean equalsAfferents(Object object) {
        if (this.equals(object)) {
            Collection collection = ((JavaPackage)object).getAfferents();
            if (this.getAfferents().size() == collection.size()) {
                Iterator iterator = this.getAfferents().iterator();
                while (iterator.hasNext()) {
                    JavaPackage javaPackage = (JavaPackage)iterator.next();
                    if (collection.contains(javaPackage)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equalsEfferents(Object object) {
        if (this.equals(object)) {
            Collection collection = ((JavaPackage)object).getEfferents();
            if (this.getEfferents().size() == collection.size()) {
                Iterator iterator = this.getEfferents().iterator();
                while (iterator.hasNext()) {
                    JavaPackage javaPackage = (JavaPackage)iterator.next();
                    if (collection.contains(javaPackage)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

