/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class PackageFilter {
    private Collection _filtered;
    private File _filterFile;
    private static final String FILTER_FILE = "jdepend.properties";
    private String[] _defaultFilters = new String[]{"java.", "javax."};

    public PackageFilter() {
        this._filtered = new ArrayList();
        this.addFilteredPackageNames();
    }

    public PackageFilter(Collection collection) {
        this._filtered = collection;
    }

    public PackageFilter(File file) {
        this._filtered = new ArrayList();
        this.setFilterFile(file);
        this.addFilteredPackageNames();
    }

    public boolean accept(String string) {
        if (this._filtered != null) {
            Iterator iterator = this._filtered.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string.startsWith(string2)) continue;
                return false;
            }
        }
        return true;
    }

    public void addPackage(String string) {
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0) {
            this._filtered.add(string);
        }
    }

    protected void addFilteredPackageNames() {
        int n = 0;
        while (n < this._defaultFilters.length) {
            this.addPackage(this._defaultFilters[n]);
            ++n;
        }
        Properties properties = this.loadProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("ignore")) continue;
            String string2 = properties.getProperty(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string3 = string3.trim();
                this.addPackage(string3);
            }
        }
    }

    protected void setFilterFile(File file) {
        this._filterFile = file;
    }

    protected File getFilterFile() {
        if (this._filterFile == null) {
            this._filterFile = this.getDefaultFilterFile();
        }
        return this._filterFile;
    }

    protected File getDefaultFilterFile() {
        String string = System.getProperty("user.home");
        return new File(string, FILTER_FILE);
    }

    /*
     * Loose catch block
     */
    protected Properties loadProperties() {
        Properties properties;
        block14: {
            InputStream inputStream;
            block13: {
                properties = new Properties();
                inputStream = null;
                try {
                    inputStream = new FileInputStream(this.getFilterFile());
                }
                catch (Exception exception) {
                    inputStream = this.getClass().getResourceAsStream("/jdepend.properties");
                }
                if (inputStream == null) break block13;
                properties.load(inputStream);
            }
            Object var5_5 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block14;
            }
            catch (IOException iOException) {}
            break block14;
            {
                catch (IOException iOException) {
                    Object var5_6 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }
}

