/*
 * Decompiled with CFR 0.152.
 */
package jdepend.swingui;

import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageComparator;

public abstract class PackageNode {
    private PackageNode _parent;
    private JavaPackage _jPackage;
    private ArrayList _children;
    private static NumberFormat _formatter = NumberFormat.getInstance();

    public PackageNode(PackageNode packageNode, JavaPackage javaPackage) {
        this._parent = packageNode;
        this._jPackage = javaPackage;
        this._children = null;
    }

    public JavaPackage getPackage() {
        return this._jPackage;
    }

    public PackageNode getParent() {
        return this._parent;
    }

    public boolean isLeaf() {
        return this.getCoupledPackages().size() <= 0;
    }

    protected abstract PackageNode makeNode(PackageNode var1, JavaPackage var2);

    protected abstract Collection getCoupledPackages();

    public boolean isChild(JavaPackage javaPackage) {
        return true;
    }

    public ArrayList getChildren() {
        if (this._children == null) {
            this._children = new ArrayList();
            ArrayList arrayList = new ArrayList(this.getCoupledPackages());
            Collections.sort(arrayList, new PackageComparator(PackageComparator.byName()));
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                JavaPackage javaPackage = (JavaPackage)iterator.next();
                if (!this.isChild(javaPackage)) continue;
                PackageNode packageNode = this.makeNode(this, javaPackage);
                this._children.add(packageNode);
            }
        }
        return this._children;
    }

    public String toMetricsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPackage().getName());
        stringBuffer.append("  (");
        stringBuffer.append("CC: " + this.getPackage().getConcreteClassCount() + "  ");
        stringBuffer.append("AC: " + this.getPackage().getAbstractClassCount() + "  ");
        stringBuffer.append("Ca: " + this.getPackage().afferentCoupling() + "  ");
        stringBuffer.append("Ce: " + this.getPackage().efferentCoupling() + "  ");
        stringBuffer.append("A: " + PackageNode.format(this.getPackage().abstractness()) + "  ");
        stringBuffer.append("I: " + PackageNode.format(this.getPackage().instability()) + "  ");
        stringBuffer.append("D: " + PackageNode.format(this.getPackage().distance()));
        if (this.getPackage().containsCycle()) {
            stringBuffer.append(" Cyclic");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.getParent().getParent() == null) {
            return this.toMetricsString();
        }
        return this.getPackage().getName();
    }

    private static String format(float f) {
        return _formatter.format(f);
    }

    static {
        _formatter.setMaximumFractionDigits(2);
    }
}

