/*
 * Decompiled with CFR 0.152.
 */
package jdepend.textui;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageComparator;

public class JDepend {
    private jdepend.framework.JDepend _analyzer = new jdepend.framework.JDepend();
    private PrintWriter _writer;
    protected NumberFormat _formatter = NumberFormat.getInstance();

    public JDepend() {
        this(new PrintWriter(System.out));
    }

    public JDepend(PrintWriter printWriter) {
        this._formatter.setMaximumFractionDigits(2);
        this.setWriter(printWriter);
    }

    public void setWriter(PrintWriter printWriter) {
        this._writer = printWriter;
    }

    protected PrintWriter getWriter() {
        return this._writer;
    }

    public void addDirectory(String string) throws IOException {
        this._analyzer.addDirectory(string);
    }

    public void analyze() {
        this.printHeader();
        Collection collection = this._analyzer.analyze();
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, new PackageComparator(PackageComparator.byName()));
        this.printPackages(arrayList);
        this.printCycles(arrayList);
        this.printSummary(arrayList);
        this.printFooter();
        this.getWriter().flush();
    }

    protected void printPackages(Collection collection) {
        this.printPackagesHeader();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.printPackage((JavaPackage)iterator.next());
        }
        this.printPackagesFooter();
    }

    protected void printPackage(JavaPackage javaPackage) {
        this.printPackageHeader(javaPackage);
        if (javaPackage.getClasses().size() == 0) {
            this.printNoStats();
            this.printPackageFooter(javaPackage);
            return;
        }
        this.printStatistics(javaPackage);
        this.printSectionBreak();
        this.printAbstractClasses(javaPackage);
        this.printSectionBreak();
        this.printConcreteClasses(javaPackage);
        this.printSectionBreak();
        this.printEfferents(javaPackage);
        this.printSectionBreak();
        this.printAfferents(javaPackage);
        this.printPackageFooter(javaPackage);
    }

    protected void printAbstractClasses(JavaPackage javaPackage) {
        this.printAbstractClassesHeader();
        ArrayList arrayList = new ArrayList(javaPackage.getClasses());
        Collections.sort(arrayList, new JavaClass.ClassComparator());
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (!javaClass.isAbstract()) continue;
            this.printClassName(javaClass);
        }
        this.printAbstractClassesFooter();
    }

    protected void printConcreteClasses(JavaPackage javaPackage) {
        this.printConcreteClassesHeader();
        ArrayList arrayList = new ArrayList(javaPackage.getClasses());
        Collections.sort(arrayList, new JavaClass.ClassComparator());
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (javaClass.isAbstract()) continue;
            this.printClassName(javaClass);
        }
        this.printConcreteClassesFooter();
    }

    protected void printEfferents(JavaPackage javaPackage) {
        this.printEfferentsHeader();
        ArrayList arrayList = new ArrayList(javaPackage.getEfferents());
        Collections.sort(arrayList, new PackageComparator(PackageComparator.byName()));
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage2 = (JavaPackage)iterator.next();
            this.printPackageName(javaPackage2);
        }
        if (arrayList.size() == 0) {
            this.printEfferentsError();
        }
        this.printEfferentsFooter();
    }

    protected void printAfferents(JavaPackage javaPackage) {
        this.printAfferentsHeader();
        ArrayList arrayList = new ArrayList(javaPackage.getAfferents());
        Collections.sort(arrayList, new PackageComparator(PackageComparator.byName()));
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage2 = (JavaPackage)iterator.next();
            this.printPackageName(javaPackage2);
        }
        if (arrayList.size() == 0) {
            this.printAfferentsError();
        }
        this.printAfferentsFooter();
    }

    protected void printCycles(Collection collection) {
        this.printCyclesHeader();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.printCycle((JavaPackage)iterator.next());
        }
        this.printCyclesFooter();
    }

    protected void printCycle(JavaPackage javaPackage) {
        ArrayList arrayList = new ArrayList();
        javaPackage.collectCycle(arrayList);
        if (!javaPackage.containsCycle()) {
            return;
        }
        JavaPackage javaPackage2 = (JavaPackage)arrayList.get(arrayList.size() - 1);
        String string = javaPackage2.getName();
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage3 = (JavaPackage)iterator.next();
            if (++n == 1) {
                this.printCycleHeader(javaPackage3);
                continue;
            }
            if (javaPackage3.getName() == string) {
                this.printCycleTarget(javaPackage3);
                continue;
            }
            this.printCycleContributor(javaPackage3);
        }
        this.printCycleFooter();
    }

    protected void printHeader() {
    }

    protected void printFooter() {
    }

    protected void printPackagesHeader() {
    }

    protected void printPackagesFooter() {
    }

    protected void printNoStats() {
        this.getWriter().println("No stats available: package referenced, but not analyzed.");
    }

    protected void printPackageHeader(JavaPackage javaPackage) {
        this.getWriter().println("\n--------------------------------------------------");
        this.getWriter().println("- Package: " + javaPackage.getName());
        this.getWriter().println("--------------------------------------------------");
    }

    protected void printPackageFooter(JavaPackage javaPackage) {
    }

    protected void printStatistics(JavaPackage javaPackage) {
        this.getWriter().println("\nStats:");
        this.getWriter().println(this.tab() + "Total Classes: " + javaPackage.getClassCount());
        this.getWriter().println(this.tab() + "Concrete Classes: " + javaPackage.getConcreteClassCount());
        this.getWriter().println(this.tab() + "Abstract Classes: " + javaPackage.getAbstractClassCount());
        this.getWriter().println("");
        this.getWriter().println(this.tab() + "Ca: " + javaPackage.afferentCoupling());
        this.getWriter().println(this.tab() + "Ce: " + javaPackage.efferentCoupling());
        this.getWriter().println("");
        this.getWriter().println(this.tab() + "A: " + this.toFormattedString(javaPackage.abstractness()));
        this.getWriter().println(this.tab() + "I: " + this.toFormattedString(javaPackage.instability()));
        this.getWriter().println(this.tab() + "D: " + this.toFormattedString(javaPackage.distance()));
    }

    protected void printClassName(JavaClass javaClass) {
        this.getWriter().println(this.tab() + javaClass.getName());
    }

    protected void printPackageName(JavaPackage javaPackage) {
        this.getWriter().println(this.tab() + javaPackage.getName());
    }

    protected void printAbstractClassesHeader() {
        this.getWriter().println("Abstract Classes:");
    }

    protected void printAbstractClassesFooter() {
    }

    protected void printConcreteClassesHeader() {
        this.getWriter().println("Concrete Classes:");
    }

    protected void printConcreteClassesFooter() {
    }

    protected void printEfferentsHeader() {
        this.getWriter().println("Depends Upon:");
    }

    protected void printEfferentsFooter() {
    }

    protected void printEfferentsError() {
        this.getWriter().println(this.tab() + "Not dependent on any packages.");
    }

    protected void printAfferentsHeader() {
        this.getWriter().println("Used By:");
    }

    protected void printAfferentsFooter() {
    }

    protected void printAfferentsError() {
        this.getWriter().println(this.tab() + "Not used by any packages.");
    }

    protected void printCyclesHeader() {
        this.printSectionBreak();
        this.getWriter().println("\n--------------------------------------------------");
        this.getWriter().println("- Package Dependency Cycles:");
        this.getWriter().println("--------------------------------------------------\n");
    }

    protected void printCyclesFooter() {
    }

    protected void printCycleHeader(JavaPackage javaPackage) {
        this.getWriter().println(javaPackage.getName());
        this.getWriter().println(this.tab() + "|");
    }

    protected void printCycleTarget(JavaPackage javaPackage) {
        this.getWriter().println(this.tab() + "|-> " + javaPackage.getName());
    }

    protected void printCycleContributor(JavaPackage javaPackage) {
        this.getWriter().println(this.tab() + "|   " + javaPackage.getName());
    }

    protected void printCycleFooter() {
        this.printSectionBreak();
    }

    protected void printSummary(Collection collection) {
        this.getWriter().println("\n--------------------------------------------------");
        this.getWriter().println("- Summary:");
        this.getWriter().println("--------------------------------------------------\n");
        this.getWriter().println("Name, Class Count, Abstract Class Count, Ca, Ce, A, I, D:\n");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage = (JavaPackage)iterator.next();
            this.getWriter().print(javaPackage.getName() + ",");
            this.getWriter().print(javaPackage.getClassCount() + ",");
            this.getWriter().print(javaPackage.getAbstractClassCount() + ",");
            this.getWriter().print(javaPackage.afferentCoupling() + ",");
            this.getWriter().print(javaPackage.efferentCoupling() + ",");
            this.getWriter().print(this.toFormattedString(javaPackage.abstractness()) + ",");
            this.getWriter().print(this.toFormattedString(javaPackage.instability()) + ",");
            this.getWriter().println(this.toFormattedString(javaPackage.distance()));
        }
    }

    protected void printSectionBreak() {
        this.getWriter().println("");
    }

    protected String toFormattedString(float f) {
        return this._formatter.format(f);
    }

    protected String tab() {
        return "    ";
    }

    protected String tab(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.tab());
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void usage(String string) {
        if (string != null) {
            System.err.println("\n" + string);
        }
        String string2 = "\nJDepend ";
        System.err.println("");
        System.err.println("usage: ");
        System.err.println(string2 + "[-file <output file>] <directory> " + "[directory2 [directory 3] ...]");
        System.exit(1);
    }

    protected void instanceMain(String[] stringArray) {
        if (stringArray.length < 1) {
            this.usage("Must specify at least one directory.");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("-")) {
                if (stringArray[n2].equalsIgnoreCase("-file")) {
                    if (stringArray.length <= n2 + 1) {
                        this.usage("Output file name not specified.");
                    }
                    try {
                        this.setWriter(new PrintWriter(new FileWriter(stringArray[++n2])));
                    }
                    catch (IOException iOException) {
                        this.usage(iOException.getMessage());
                    }
                } else {
                    this.usage("Invalid argument: " + stringArray[n2]);
                }
            } else {
                try {
                    this.addDirectory(stringArray[n2]);
                    ++n;
                }
                catch (IOException iOException) {
                    this.usage("Directory does not exist: " + stringArray[n2]);
                }
            }
            ++n2;
        }
        if (n == 0) {
            this.usage("Must specify at least one directory.");
        }
        this.analyze();
    }

    public static void main(String[] stringArray) {
        new JDepend().instanceMain(stringArray);
    }
}

