/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.nni.BLAS;

class NNI_BLASkernel
implements BLASkernel {
    public NNI_BLASkernel() {
        BLAS.init();
    }

    public double dot(int N, double[] X, double[] Y) {
        return BLAS.dot(N, X, 1, Y, 1);
    }

    public double nrm2(int N, double[] X) {
        return BLAS.nrm2(N, X, 1);
    }

    public double asum(int N, double[] X) {
        return BLAS.asum(N, X, 1);
    }

    public int idamax(int N, double[] X) {
        return BLAS.idamax(N, X, 1);
    }

    public void swap(int N, double[] X, double[] Y) {
        BLAS.swap(N, X, 1, Y, 1);
    }

    public void copy(int N, double[] X, double[] Y) {
        BLAS.copy(N, X, 1, Y, 1);
    }

    public void axpy(int N, double alpha, double[] X, double[] Y) {
        BLAS.axpy(N, alpha, X, 1, Y, 1);
    }

    public void scal(int N, double alpha, double[] X) {
        BLAS.scal(N, alpha, X, 1);
    }

    public void gemv(BLASkernel.Transpose TransA, int M, int N, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        BLAS.gemv(102, this.trans(TransA), M, N, alpha, A, lda, X, 1, beta, Y, 1);
    }

    public void gbmv(BLASkernel.Transpose TransA, int M, int N, int KL, int KU, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        BLAS.gbmv(102, this.trans(TransA), M, N, KL, KU, alpha, A, lda, X, 1, beta, Y, 1);
    }

    public void trmv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N, double[] A, int lda, double[] X) {
        BLAS.trmv(102, this.uplo(uplo), this.trans(TransA), this.diag(diag), N, A, lda, X, 1);
    }

    public void tbmv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N, int K, double[] A, int lda, double[] X) {
        BLAS.tbmv(102, this.uplo(uplo), this.trans(TransA), this.diag(diag), N, K, A, lda, X, 1);
    }

    public void tpmv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N, double[] Ap2, double[] X) {
        BLAS.tpmv(102, this.uplo(uplo), this.trans(TransA), this.diag(diag), N, Ap2, X, 1);
    }

    public void trsv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N, double[] A, int lda, double[] X) {
        BLAS.trsv(102, this.uplo(uplo), this.trans(TransA), this.diag(diag), N, A, lda, X, 1);
    }

    public void tbsv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N, int K, double[] A, int lda, double[] X) {
        BLAS.tbsv(102, this.uplo(uplo), this.trans(TransA), this.diag(diag), N, K, A, lda, X, 1);
    }

    public void tpsv(BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int N, double[] Ap2, double[] X) {
        BLAS.tpsv(102, this.uplo(uplo), this.trans(TransA), this.diag(diag), N, Ap2, X, 1);
    }

    public void symv(BLASkernel.UpLo uplo, int N, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        BLAS.symv(102, this.uplo(uplo), N, alpha, A, lda, X, 1, beta, Y, 1);
    }

    public void sbmv(BLASkernel.UpLo uplo, int N, int K, double alpha, double[] A, int lda, double[] X, double beta, double[] Y) {
        BLAS.sbmv(102, this.uplo(uplo), N, K, alpha, A, lda, X, 1, beta, Y, 1);
    }

    public void spmv(BLASkernel.UpLo uplo, int N, double alpha, double[] Ap2, double[] X, double beta, double[] Y) {
        BLAS.spmv(102, this.uplo(uplo), N, alpha, Ap2, X, 1, beta, Y, 1);
    }

    public void ger(int M, int N, double alpha, double[] X, double[] Y, double[] A, int lda) {
        BLAS.ger(102, M, N, alpha, X, 1, Y, 1, A, lda);
    }

    public void syr(BLASkernel.UpLo uplo, int N, double alpha, double[] X, double[] A, int lda) {
        BLAS.syr(102, this.uplo(uplo), N, alpha, X, 1, A, lda);
    }

    public void spr(BLASkernel.UpLo uplo, int N, double alpha, double[] X, double[] Ap2) {
        BLAS.spr(102, this.uplo(uplo), N, alpha, X, 1, Ap2);
    }

    public void syr2(BLASkernel.UpLo uplo, int N, double alpha, double[] X, double[] Y, double[] A, int lda) {
        BLAS.syr2(102, this.uplo(uplo), N, alpha, X, 1, Y, 1, A, lda);
    }

    public void spr2(BLASkernel.UpLo uplo, int N, double alpha, double[] X, double[] Y, double[] Ap2) {
        BLAS.spr2(102, this.uplo(uplo), N, alpha, X, 1, Y, 1, Ap2);
    }

    public void gemm(BLASkernel.Transpose TransA, BLASkernel.Transpose TransB, int M, int N, int K, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        BLAS.gemm(102, this.trans(TransA), this.trans(TransB), M, N, K, alpha, A, lda, B, ldb, beta, C, ldc);
    }

    public void symm(BLASkernel.Side side, BLASkernel.UpLo uplo, int M, int N, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        BLAS.symm(102, this.side(side), this.uplo(uplo), M, N, alpha, A, lda, B, ldb, beta, C, ldc);
    }

    public void syrk(BLASkernel.UpLo uplo, BLASkernel.Transpose Trans, int N, int K, double alpha, double[] A, int lda, double beta, double[] C, int ldc) {
        BLAS.syrk(102, this.uplo(uplo), this.trans(Trans), N, K, alpha, A, lda, beta, C, ldc);
    }

    public void syr2k(BLASkernel.UpLo uplo, BLASkernel.Transpose Trans, int N, int K, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        BLAS.syr2k(102, this.uplo(uplo), this.trans(Trans), N, K, alpha, A, lda, B, ldb, beta, C, ldc);
    }

    public void trmm(BLASkernel.Side side, BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int M, int N, double alpha, double[] A, int lda, double[] B, int ldb) {
        BLAS.trmm(102, this.side(side), this.uplo(uplo), this.trans(TransA), this.diag(diag), M, N, alpha, A, lda, B, ldb);
    }

    public void trsm(BLASkernel.Side side, BLASkernel.UpLo uplo, BLASkernel.Transpose TransA, BLASkernel.Diag diag, int M, int N, double alpha, double[] A, int lda, double[] B, int ldb) {
        BLAS.trsm(102, this.side(side), this.uplo(uplo), this.trans(TransA), this.diag(diag), M, N, alpha, A, lda, B, ldb);
    }

    private int trans(BLASkernel.Transpose trans) {
        if (trans == BLASkernel.Transpose.NoTranspose) {
            return 111;
        }
        return 112;
    }

    private int side(BLASkernel.Side side) {
        if (side == BLASkernel.Side.Left) {
            return 141;
        }
        return 142;
    }

    private int uplo(BLASkernel.UpLo uplo) {
        if (uplo == BLASkernel.UpLo.Lower) {
            return 122;
        }
        return 121;
    }

    private int diag(BLASkernel.Diag diag) {
        if (diag == BLASkernel.Diag.NonUnit) {
            return 131;
        }
        return 132;
    }
}

