/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.PrintWriter;
import pal.alignment.Alignment;
import pal.alignment.CostBag;
import pal.alignment.SimpleAlignment;
import pal.datatype.AminoAcids;
import pal.datatype.CodonTable;
import pal.datatype.CodonTableFactory;
import pal.datatype.DataType;
import pal.datatype.DataTypeUtils;
import pal.datatype.GeneralizedCodons;
import pal.datatype.Nucleotides;
import pal.datatype.TransitionPenaltyTable;
import pal.datatype.TwoStates;
import pal.io.FormattedOutput;
import pal.misc.IdGroup;
import pal.misc.SimpleIdGroup;

public class AlignmentUtils {
    static FormattedOutput format = FormattedOutput.getInstance();

    public static void report(Alignment a, PrintWriter out) {
        if (a.getDataType() == null) {
            a.setDataType(AlignmentUtils.getSuitableInstance(a));
        }
        out.println("Number of sequences: " + a.getSequenceCount());
        out.println("Number of sites: " + a.getSiteCount());
        out.println("Data type: " + a.getDataType().getDescription() + " data");
    }

    public static void print(Alignment a, PrintWriter out) {
        AlignmentUtils.printInterleaved(a, out);
    }

    public static void printPlain(Alignment a, PrintWriter out) {
        AlignmentUtils.printPlain(a, out, false);
    }

    public static void printPlain(Alignment a, PrintWriter out, boolean relaxed) {
        out.println("  " + a.getSequenceCount() + " " + a.getSiteCount());
        int s = 0;
        while (s < a.getSequenceCount()) {
            format.displayLabel(out, a.getIdentifier(s).getName(), relaxed ? 20 : 10);
            out.print("     ");
            AlignmentUtils.printNextSites(a, out, false, s, 0, a.getSiteCount());
            out.println();
            ++s;
        }
    }

    public static void printSequential(Alignment a, PrintWriter out) {
        out.println("  " + a.getSequenceCount() + " " + a.getSiteCount() + "  S");
        int s = 0;
        while (s < a.getSequenceCount()) {
            int n = 0;
            while (n < a.getSiteCount()) {
                if (n == 0) {
                    format.displayLabel(out, a.getIdentifier(s).getName(), 10);
                    out.print("     ");
                } else {
                    out.print("               ");
                }
                AlignmentUtils.printNextSites(a, out, false, s, n, 50);
                out.println();
                n += 50;
            }
            ++s;
        }
    }

    public static void printInterleaved(Alignment a, PrintWriter out) {
        int n = 0;
        out.println("  " + a.getSequenceCount() + " " + a.getSiteCount());
        while (n < a.getSiteCount()) {
            int s = 0;
            while (s < a.getSequenceCount()) {
                if (n == 0) {
                    format.displayLabel(out, a.getIdentifier(s).getName(), 10);
                    out.print("     ");
                } else {
                    out.print("               ");
                }
                AlignmentUtils.printNextSites(a, out, true, s, n, 50);
                out.println();
                ++s;
            }
            out.println();
            n += 50;
        }
    }

    public static void printCLUSTALW(Alignment a, PrintWriter out) {
        int n = 0;
        out.println("CLUSTAL W multiple sequence alignment");
        out.println();
        while (n < a.getSiteCount()) {
            out.println();
            int s = 0;
            while (s < a.getSequenceCount()) {
                format.displayLabel(out, a.getIdentifier(s).getName(), 10);
                out.print("     ");
                AlignmentUtils.printNextSites(a, out, false, s, n, 50);
                out.println();
                ++s;
            }
            out.println("               ");
            n += 50;
        }
    }

    public static final void getAlignedSequenceIndices(Alignment a, int i, int[] indices, DataType dataType) {
        String sequence = a.getAlignedSequenceString(i);
        int j = 0;
        while (j < a.getSiteCount()) {
            indices[j] = dataType.getState(sequence.charAt(j));
            ++j;
        }
    }

    public static double getAlignmentPenalty(Alignment a, TransitionPenaltyTable penalties, double gapCreation, double gapExtension) {
        return AlignmentUtils.getAlignmentPenalty(a, a.getDataType(), penalties, gapCreation, gapExtension, false);
    }

    public static double getAlignmentPenalty(Alignment a, DataType dataType, TransitionPenaltyTable penalties, double gapCreation, double gapExtension, boolean local) {
        int[][] indices = new int[a.getSequenceCount()][a.getSiteCount()];
        int i = 0;
        while (i < a.getSequenceCount()) {
            AlignmentUtils.getAlignedSequenceIndices(a, i, indices[i], dataType);
            ++i;
        }
        CostBag totalBag = new CostBag();
        int i2 = 0;
        while (i2 < a.getSequenceCount()) {
            int j = i2 + 1;
            while (j < a.getSequenceCount()) {
                totalBag.add(AlignmentUtils.getAlignmentPenalty(a, penalties, i2, j, indices[i2], indices[j], local));
                ++j;
            }
            ++i2;
        }
        return totalBag.score(gapCreation, gapExtension);
    }

    public static DataType getSuitableInstance(Alignment alignment) {
        long numNucs = 0L;
        long numChars = 0L;
        long numBins = 0L;
        int i = 0;
        while (i < alignment.getSequenceCount()) {
            int j = 0;
            while (j < alignment.getSiteCount()) {
                char c = alignment.getData(i, j);
                if (c == 'A' || c == 'C' || c == 'G' || c == 'T' || c == 'U' || c == 'N') {
                    ++numNucs;
                }
                if (c != '-' && c != '?') {
                    ++numChars;
                }
                if (c == '0' || c == '1') {
                    ++numBins;
                }
                ++j;
            }
            ++i;
        }
        if (numChars == 0L) {
            numChars = 1L;
        }
        if ((double)numNucs / (double)numChars > 0.85) {
            return new Nucleotides();
        }
        if ((double)numBins / (double)numChars > 0.2) {
            return new TwoStates();
        }
        return new AminoAcids();
    }

    public static double[] estimateFrequencies(Alignment a) {
        if (a.getDataType() == null) {
            a.setDataType(AlignmentUtils.getSuitableInstance(a));
        }
        int numStates = a.getDataType().getNumStates();
        double[] frequency = new double[numStates];
        long[] stateCount = new long[numStates + 1];
        int i = 0;
        while (i < numStates + 1) {
            stateCount[i] = 0L;
            ++i;
        }
        int i2 = 0;
        while (i2 < a.getSequenceCount()) {
            int j = 0;
            while (j < a.getSiteCount()) {
                int n = a.getDataType().getState(a.getData(i2, j));
                stateCount[n] = stateCount[n] + 1L;
                ++j;
            }
            ++i2;
        }
        long sumStates = (long)(a.getSiteCount() * a.getSequenceCount()) - stateCount[numStates];
        int i3 = 0;
        while (i3 < numStates) {
            frequency[i3] = (double)stateCount[i3] / (double)sumStates;
            ++i3;
        }
        a.setFrequency(frequency);
        return frequency;
    }

    public static final boolean isSiteRedundant(Alignment a, int site) {
        int numSeq = a.getSequenceCount();
        int i = 0;
        while (i < numSeq) {
            if (!AlignmentUtils.isGap(a, i, site)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final Alignment removeRedundantSites(Alignment a) {
        boolean[] keep = new boolean[a.getSiteCount()];
        int toKeep = 0;
        int i = 0;
        while (i < keep.length) {
            boolean bl = keep[i] = !AlignmentUtils.isSiteRedundant(a, i);
            if (keep[i]) {
                ++toKeep;
            }
            ++i;
        }
        String[] newSeqs = new String[a.getSequenceCount()];
        int numberOfSites = a.getSiteCount();
        int i2 = 0;
        while (i2 < newSeqs.length) {
            StringBuffer sb = new StringBuffer(toKeep);
            int j = 0;
            while (j < numberOfSites) {
                if (keep[j]) {
                    sb.append(a.getData(i2, j));
                }
                ++j;
            }
            newSeqs[i2] = sb.toString();
            ++i2;
        }
        return new SimpleAlignment((IdGroup)a, newSeqs);
    }

    public static boolean isGap(Alignment a, int seq, int site) {
        return DataTypeUtils.isGap(a.getDataType(), a.getData(seq, site));
    }

    public static void getPositionMisalignmentInfo(Alignment a, PrintWriter out, int startingCodonPosition, CodonTable translator, boolean removeIncompleteCodons) {
        DataType dt = a.getDataType();
        int i = 0;
        while (i < a.getSequenceCount()) {
            int codonPosition = startingCodonPosition;
            String codon = "";
            boolean first = true;
            out.print(a.getIdentifier(i) + ":");
            int leftGaps = 0;
            int rightGaps = 0;
            int j = 0;
            while (j < a.getSiteCount()) {
                char c = a.getData(i, j);
                if (dt.isUnknownChar(c)) {
                    switch (codonPosition) {
                        case 1: {
                            ++leftGaps;
                            break;
                        }
                        case 2: {
                            ++rightGaps;
                            break;
                        }
                        default: {
                            out.print(c);
                            break;
                        }
                    }
                } else {
                    codon = codon + c;
                    if (codonPosition == 2) {
                        if (!(first && first && codon.length() != 3 && removeIncompleteCodons)) {
                            if (!first || first && startingCodonPosition == 0) {
                                out.print('[');
                            }
                            AlignmentUtils.outputChar(out, '-', leftGaps);
                            out.print(translator.getAminoAcidChar(codon.toCharArray()));
                            AlignmentUtils.outputChar(out, '-', rightGaps);
                            out.print(']');
                        }
                        first = false;
                        codon = "";
                        leftGaps = 0;
                        rightGaps = 0;
                    }
                    codonPosition = (codonPosition + 1) % 3;
                }
                ++j;
            }
            if (!removeIncompleteCodons && codonPosition != 0) {
                out.print('[');
                AlignmentUtils.outputChar(out, '-', leftGaps);
                out.print('?');
                AlignmentUtils.outputChar(out, '-', rightGaps);
            }
            out.print("\n");
            ++i;
        }
    }

    public static void getPositionMisalignmentInfo(Alignment a, PrintWriter out, int startingCodonPosition) {
        int i = 0;
        while (i < a.getSequenceCount()) {
            int codonPosition = startingCodonPosition;
            out.print(a.getIdentifier(i) + ":");
            int j = 0;
            while (j < a.getSiteCount()) {
                char c = a.getData(i, j);
                if (AlignmentUtils.isGap(a, i, j)) {
                    out.print(c);
                } else {
                    switch (codonPosition) {
                        case 0: {
                            out.print('[');
                            break;
                        }
                        case 1: {
                            out.print(c);
                            break;
                        }
                        case 2: {
                            out.print(']');
                        }
                    }
                    codonPosition = (codonPosition + 1) % 3;
                }
                ++j;
            }
            out.print("\n");
            ++i;
        }
    }

    public static final Alignment concatAlignments(Alignment[] alignments, DataType dt) {
        int maxSequence = -1;
        Alignment maxAlignment = null;
        int length = 0;
        int i = 0;
        while (i < alignments.length) {
            if (alignments[i].getSequenceCount() > maxSequence) {
                maxAlignment = alignments[i];
                maxSequence = alignments[i].getSequenceCount();
            }
            length += alignments[i].getSiteCount();
            ++i;
        }
        char[][] sequences = new char[maxSequence][length];
        int j = 0;
        while (j < sequences.length) {
            int base = 0;
            int i2 = 0;
            while (i2 < alignments.length) {
                int k;
                if (alignments[i2].getSequenceCount() <= j) {
                    k = 0;
                    while (k < alignments[i2].getSiteCount()) {
                        sequences[j][base + k] = 45;
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < alignments[i2].getSiteCount()) {
                        sequences[j][base + k] = alignments[i2].getData(j, k);
                        ++k;
                    }
                }
                base += alignments[i2].getSiteCount();
                ++i2;
            }
            ++j;
        }
        SimpleAlignment sa = new SimpleAlignment((IdGroup)maxAlignment, sequences);
        sa.setDataType(dt);
        return sa;
    }

    public static final char[] getSequenceCharArray(Alignment a, int sequence) {
        char[] cs = new char[a.getSiteCount()];
        int i = 0;
        while (i < cs.length) {
            cs[i] = a.getData(sequence, i);
            ++i;
        }
        return cs;
    }

    public static final String getSequenceString(Alignment a, int sequence) {
        return new String(AlignmentUtils.getSequenceCharArray(a, sequence));
    }

    public static final Alignment getChangedDataType(Alignment a, DataType dt) {
        int numberOfSites = a.getSiteCount();
        boolean[] include = new boolean[numberOfSites];
        int goodSiteCount = 0;
        int i = 0;
        while (i < numberOfSites) {
            include[i] = AlignmentUtils.isGoodSite(a, dt, i);
            if (include[i]) {
                ++goodSiteCount;
            }
            ++i;
        }
        String[] sequences = new String[a.getSequenceCount()];
        int i2 = 0;
        while (i2 < sequences.length) {
            char[] seq = new char[goodSiteCount];
            int count = 0;
            int j = 0;
            while (j < numberOfSites) {
                if (include[j]) {
                    seq[count] = a.getData(i2, j);
                    ++count;
                }
                ++j;
            }
            sequences[i2] = new String(seq);
            ++i2;
        }
        SimpleAlignment sa = new SimpleAlignment((IdGroup)new SimpleIdGroup(a), sequences);
        sa.setDataType(dt);
        return sa;
    }

    public static final int countUnknowns(Alignment a, DataType dt) {
        int count = 0;
        int i = 0;
        while (i < a.getSequenceCount()) {
            int j = 0;
            while (j < a.getSiteCount()) {
                if (dt.isUnknownState(dt.getState(a.getData(i, j)))) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public static final Alignment getNucleotideAlignment(Alignment base) {
        DataType dt = base.getDataType();
        switch (dt.getTypeID()) {
            case 4: {
                return AlignmentUtils.translateCodon(base);
            }
            case 5: {
                return AlignmentUtils.translateCodon(base);
            }
            case 1: {
                return AlignmentUtils.translateAA(base);
            }
        }
        return base;
    }

    public static final char[][] getNucleotideAlignment(char[][] base, DataType baseDataType) {
        switch (baseDataType.getTypeID()) {
            case 4: {
                return AlignmentUtils.translateCodon(base);
            }
            case 5: {
                return AlignmentUtils.translateCodon(base);
            }
            case 1: {
                return AlignmentUtils.translateAA(base);
            }
        }
        return base;
    }

    private static final void outputChar(PrintWriter out, char c, int number) {
        int i = 0;
        while (i < number) {
            out.print(c);
            ++i;
        }
    }

    private static void printNextSites(Alignment a, PrintWriter out, boolean chunked, int seq, int start, int num) {
        int i = 0;
        while (i < num && start + i < a.getSiteCount()) {
            if (i % 10 == 0 && i != 0 && chunked) {
                out.print(' ');
            }
            out.print(a.getData(seq, start + i));
            ++i;
        }
    }

    private static int getNaturalGapCost(Alignment a, int x, int y, int start, int finish) {
        int totalCost = 0;
        boolean inGap = false;
        int i = start;
        while (i <= finish) {
            if (!AlignmentUtils.isGap(a, y, i) || !AlignmentUtils.isGap(a, x, i)) {
                if (AlignmentUtils.isGap(a, x, i)) {
                    if (!inGap) {
                        ++totalCost;
                        inGap = true;
                    }
                } else {
                    inGap = false;
                }
            }
            ++i;
        }
        return totalCost;
    }

    private static final boolean isGoodSite(Alignment a, DataType dt, int site) {
        int numberOfSequences = a.getSequenceCount();
        int i = 0;
        while (i < numberOfSequences) {
            char c = a.getData(i, site);
            if (c != '-' && dt.isUnknownState(dt.getState(c))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static CostBag getAlignmentPenalty(Alignment a, TransitionPenaltyTable penalties, int x, int y, int[] xindices, int[] yindices, boolean local) {
        int start = 0;
        int finish = a.getSiteCount() - 1;
        if (local) {
            while (AlignmentUtils.isGap(a, y, start) || AlignmentUtils.isGap(a, x, start)) {
                ++start;
            }
            while (AlignmentUtils.isGap(a, y, finish) || AlignmentUtils.isGap(a, x, finish)) {
                --finish;
            }
        }
        int gapCost = AlignmentUtils.getNaturalGapCost(a, x, y, start, finish) + AlignmentUtils.getNaturalGapCost(a, y, x, start, finish);
        int gapExCost = 0;
        double subCosts = 0.0;
        int i = start;
        while (i <= finish) {
            if (AlignmentUtils.isGap(a, x, i) || AlignmentUtils.isGap(a, y, i)) {
                if (a.getData(x, i) != a.getData(y, i)) {
                    ++gapExCost;
                }
            } else {
                subCosts += penalties.penalty(xindices[i], yindices[i]);
            }
            ++i;
        }
        return new CostBag(gapCost, gapExCost, subCosts);
    }

    private static final Alignment translateCodon(Alignment base) {
        int originalSiteCount = base.getSiteCount();
        char[][] data = new char[base.getSequenceCount()][originalSiteCount * 3];
        GeneralizedCodons gc = GeneralizedCodons.DEFAULT_INSTANCE;
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < originalSiteCount) {
                char[] codon = gc.getCodonFromCodonChar(base.getData(i, j));
                int k = 0;
                while (k < 3) {
                    data[i][j * 3 + k] = codon[k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        SimpleAlignment sa = new SimpleAlignment((IdGroup)base, data);
        sa.setDataType(DataTypeUtils.getInstance(0));
        return sa;
    }

    private static final int[][] translateCodonState(int[][] base) {
        int originalSiteCount = base.length;
        int[][] data = new int[base.length][];
        GeneralizedCodons gc = GeneralizedCodons.DEFAULT_INSTANCE;
        int i = 0;
        while (i < data.length) {
            data[i] = new int[base[i].length * 3];
            int j = 0;
            while (j < base[i].length) {
                int[] codon = gc.getBaseStatesFromCodonState(base[i][j]);
                int k = 0;
                while (k < 3) {
                    data[i][j * 3 + k] = codon[k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return data;
    }

    private static final char[][] translateCodon(char[][] base) {
        int originalSiteCount = base.length;
        char[][] data = new char[base.length][];
        GeneralizedCodons gc = GeneralizedCodons.DEFAULT_INSTANCE;
        int i = 0;
        while (i < data.length) {
            data[i] = new char[base[i].length * 3];
            int j = 0;
            while (j < base[i].length) {
                char[] codon = gc.getCodonFromCodonChar(base[i][j]);
                int k = 0;
                while (k < 3) {
                    data[i][j * 3 + k] = codon[k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return data;
    }

    private static final Alignment translateAA(Alignment base) {
        int originalSiteCount = base.getSiteCount();
        char[][] data = new char[base.getSequenceCount()][originalSiteCount * 3];
        CodonTable ct = CodonTableFactory.createUniversalTranslator();
        AminoAcids aa = AminoAcids.DEFAULT_INSTANCE;
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < originalSiteCount) {
                char[] codon = ct.getCodonsFromAminoAcidChar(base.getData(i, j))[0];
                int k = 0;
                while (k < 3) {
                    data[i][j * 3 + k] = codon[k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        SimpleAlignment sa = new SimpleAlignment((IdGroup)base, data);
        sa.setDataType(DataTypeUtils.getInstance(0));
        return sa;
    }

    private static final char[][] translateAA(char[][] base) {
        char[][] data = new char[base.length][];
        CodonTable ct = CodonTableFactory.createUniversalTranslator();
        AminoAcids aa = AminoAcids.DEFAULT_INSTANCE;
        int i = 0;
        while (i < data.length) {
            data[i] = new char[base[i].length * 3];
            int j = 0;
            while (j < base[i].length) {
                char[] codon = ct.getCodonsFromAminoAcidChar(base[i][j])[0];
                int k = 0;
                while (k < 3) {
                    data[i][j * 3 + k] = codon[k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return data;
    }
}

