/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.datatype.AminoAcids;
import pal.datatype.CodonTable;
import pal.datatype.CodonTableFactory;

public class AminoAcidAlignment
extends AbstractAlignment {
    private char[][] data_;

    public AminoAcidAlignment(Alignment raw) {
        this(raw, 0);
    }

    public AminoAcidAlignment(Alignment raw, int startingCodonPosition) {
        this(raw, startingCodonPosition, CodonTableFactory.createUniversalTranslator());
    }

    public AminoAcidAlignment(Alignment raw, int startingCodonPosition, CodonTable trans) {
        this.numSeqs = raw.getSequenceCount();
        this.idGroup = raw;
        this.numSites = (raw.getSiteCount() - startingCodonPosition) / 3;
        this.dataType = new AminoAcids();
        this.data_ = new char[this.numSeqs][this.numSites];
        this.constructData(raw, startingCodonPosition, trans);
    }

    private void constructData(Alignment raw, int startingCodonPosition, CodonTable trans) {
        int i = 0;
        while (i < this.numSeqs) {
            int j = 0;
            while (j < this.numSites) {
                char[] cs = new char[3];
                int k = 0;
                while (k < 3) {
                    cs[k] = raw.getData(i, j * 3 + startingCodonPosition + k);
                    ++k;
                }
                this.data_[i][j] = trans.getAminoAcidChar(cs);
                ++j;
            }
            ++i;
        }
    }

    public char getData(int seq, int site) {
        return this.data_[seq][site];
    }
}

