/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.coalescent.DemographicModel;
import pal.io.FormattedOutput;
import pal.io.OutputTarget;
import pal.misc.Report;
import pal.misc.Units;

public class CoalescentIntervals
implements Units,
Report,
Serializable {
    public static final int COALESCENT = 0;
    public static final int NEW_SAMPLE = 1;
    public static final int NOTHING = 2;
    private double[] intervals;
    private int[] numLineages;
    private int units = 1;
    private FormattedOutput fo = FormattedOutput.getInstance();

    public CoalescentIntervals() {
    }

    public CoalescentIntervals(int size) {
        this();
        this.intervals = new double[size];
        this.numLineages = new int[size];
    }

    public void setUnits(int u) {
        this.units = u;
    }

    public int getUnits() {
        return this.units;
    }

    public int getNumLineages(int i) {
        return this.numLineages[i];
    }

    public void setNumLineages(int i, int numLines) {
        this.numLineages[i] = numLines;
    }

    public int getCoalescentEvents(int i) {
        if (i < this.intervals.length - 1) {
            return this.numLineages[i] - this.numLineages[i + 1];
        }
        return this.numLineages[i] - 1;
    }

    public int getIntervalType(int i) {
        int numEvents = this.getCoalescentEvents(i);
        if (numEvents > 0) {
            return 0;
        }
        if (numEvents < 0) {
            return 1;
        }
        return 2;
    }

    public double getInterval(int i) {
        return this.intervals[i];
    }

    public void setInterval(int i, double value) {
        this.intervals[i] = value;
    }

    public double getTotalHeight() {
        double height = 0.0;
        int j = 0;
        while (j < this.intervals.length) {
            height += this.intervals[j];
            ++j;
        }
        return height;
    }

    public int getIntervalCount() {
        return this.intervals.length;
    }

    public boolean isBinaryCoalescent() {
        int i = 0;
        while (i < this.intervals.length) {
            if (this.getCoalescentEvents(i) != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isCoalescentOnly() {
        int i = 0;
        while (i < this.intervals.length) {
            if (this.getCoalescentEvents(i) < 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void groupIntervals(CoalescentIntervals reference) {
        if (!this.isBinaryCoalescent()) {
            throw new IllegalArgumentException("CoalescentIntervals must purely consist of only single coalescents");
        }
        if (this.getNumLineages(0) != reference.getNumLineages(0)) {
            throw new IllegalArgumentException("Incompatible reference CoalescentIntervals");
        }
        int refSize = reference.getIntervalCount();
        double[] newIntervals = new double[refSize];
        int[] newNumLineages = new int[refSize];
        int count = 0;
        int i = 0;
        while (i < refSize) {
            newNumLineages[i] = reference.getNumLineages(i);
            int numEvents = reference.getCoalescentEvents(i);
            int j = 0;
            while (j < numEvents) {
                int n = i;
                newIntervals[n] = newIntervals[n] + this.intervals[count];
                ++count;
                ++j;
            }
            ++i;
        }
        this.intervals = newIntervals;
        this.numLineages = newNumLineages;
    }

    public void getSmallIntervals(double minSize, boolean[] smallInterval) {
        if (this.intervals.length != smallInterval.length) {
            throw new IllegalArgumentException("Array length incompatible");
        }
        int i = 0;
        while (i < this.intervals.length) {
            smallInterval[i] = !(this.intervals[i] > minSize);
            ++i;
        }
    }

    public void poolIntervals(boolean[] smallInterval) {
        int uniqueIntervals = 0;
        int i = 0;
        while (i < this.intervals.length) {
            if (!smallInterval[i]) {
                ++uniqueIntervals;
            }
            ++i;
        }
        if (uniqueIntervals == 0) {
            uniqueIntervals = 1;
        }
        double[] newIntervals = new double[uniqueIntervals];
        int[] newNumLineages = new int[uniqueIntervals];
        int count = 0;
        int coalescences = 0;
        int numLines = this.numLineages[0];
        int i2 = 0;
        while (i2 < this.intervals.length) {
            coalescences = i2 < this.intervals.length - 1 ? (coalescences += this.numLineages[i2] - this.numLineages[i2 + 1]) : (coalescences += this.numLineages[i2] - 1);
            newIntervals[count] = this.intervals[i2] + newIntervals[count];
            newNumLineages[count] = numLines;
            if (!smallInterval[i2]) {
                if (++count == uniqueIntervals) {
                    --count;
                }
                numLines -= coalescences;
                coalescences = 0;
            }
            ++i2;
        }
        this.intervals = newIntervals;
        this.numLineages = newNumLineages;
    }

    public void poolSmallIntervals(double minSize) {
        boolean[] smallInterval = new boolean[this.intervals.length];
        this.getSmallIntervals(minSize, smallInterval);
        this.poolIntervals(smallInterval);
    }

    public double computeLogLikelihood(DemographicModel model) {
        double total = 0.0;
        double currentTime = 0.0;
        double intervalVal = 0.0;
        try {
            int j = 0;
            while (j < this.intervals.length) {
                total += model.computeLogLikelihood(this.intervals[j], currentTime, this.numLineages[j], this.getIntervalType(j));
                int diff = this.getCoalescentEvents(j) - 1;
                int k = 0;
                while (k < diff) {
                    total += model.computeLogLikelihood(0.0, currentTime, this.numLineages[j] - k - 1, 0);
                    ++k;
                }
                currentTime += this.intervals[j];
                ++j;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            System.out.println(e);
            System.out.println(this);
        }
        return total;
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        out.println("Lin.\tCoal.\tSize\tTotal");
        double total = 0.0;
        int i = 0;
        while (i < this.intervals.length) {
            total += this.intervals[i];
            out.print(this.numLineages[i] + "\t");
            out.print(this.getCoalescentEvents(i) + "\t");
            this.fo.displayDecimal(out, this.intervals[i], 5);
            out.print("\t");
            this.fo.displayDecimal(out, total, 5);
            out.println();
            ++i;
        }
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println(this);
    }

    static {
        COALESCENT = 0;
        NEW_SAMPLE = 1;
        NOTHING = 2;
    }
}

