/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.util.Vector;
import pal.coalescent.CoalescentIntervals;
import pal.mep.MutationRateModel;
import pal.misc.Units;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.Tree;
import pal.tree.TreeUtils;
import pal.util.ComparableDouble;
import pal.util.HeapSort;

public class IntervalsExtractor
implements Units {
    public static CoalescentIntervals extractFromClockTree(Tree tree) {
        return IntervalsExtractor.extractFromClockTree(tree, -1.0);
    }

    public static CoalescentIntervals extractFromClockTree(Tree tree, double minSize) {
        tree.createNodeList();
        NodeUtils.lengths2Heights(tree.getRoot());
        Vector times = new Vector();
        Vector childs = new Vector();
        IntervalsExtractor.collectInternalNodeHeights(tree.getRoot(), times, childs);
        int[] indices = new int[times.size()];
        HeapSort.sort(times, indices);
        int uniqueIntervals = 0;
        double currentTime = 0.0;
        int i = 0;
        while (i < times.size()) {
            double time = ((ComparableDouble)times.elementAt(indices[i])).doubleValue();
            if (Math.abs(time - currentTime) > minSize) {
                ++uniqueIntervals;
            }
            currentTime = time;
            ++i;
        }
        if (uniqueIntervals == 0) {
            uniqueIntervals = 1;
        }
        CoalescentIntervals ci = new CoalescentIntervals(uniqueIntervals);
        ci.setUnits(tree.getUnits());
        double start = 0.0;
        int numLines = tree.getExternalNodeCount();
        int count = 0;
        int coalescences = 0;
        int i2 = 0;
        while (i2 < times.size()) {
            double finish = ((ComparableDouble)times.elementAt(indices[i2])).doubleValue();
            int childCount = (Integer)childs.elementAt(indices[i2]);
            double length = Math.abs(finish - start);
            coalescences += childCount - 1;
            ci.setInterval(count, length + ci.getInterval(count));
            ci.setNumLineages(count, numLines);
            if (length > minSize) {
                if (++count == uniqueIntervals) {
                    --count;
                }
                numLines -= coalescences;
                coalescences = 0;
            }
            start = finish;
            ++i2;
        }
        return ci;
    }

    public static CoalescentIntervals extractFromTree(Tree tree, MutationRateModel muModel) {
        Tree newTree = TreeUtils.mutationsToGenerations(tree, muModel);
        return IntervalsExtractor.extractFromTree(newTree);
    }

    public static CoalescentIntervals extractFromTree(Tree tree) {
        double MULTIFURCATION_LIMIT = 1.0E-9;
        if (tree.getRoot().getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(tree.getRoot());
        }
        Vector times = new Vector();
        Vector childs = new Vector();
        IntervalsExtractor.collectAllTimes(tree.getRoot(), times, childs);
        int[] indices = new int[times.size()];
        Vector<Integer> lineages = new Vector<Integer>();
        Vector<Double> intervals = new Vector<Double>();
        HeapSort.sort(times, indices);
        double start = 0.0;
        int numLines = 0;
        int i = 0;
        while (i < times.size()) {
            double finish;
            int lineagesRemoved = 0;
            int lineagesAdded = 0;
            double next = finish = ((ComparableDouble)times.elementAt(indices[i])).doubleValue();
            while (Math.abs(next - finish) < MULTIFURCATION_LIMIT) {
                int children = (Integer)childs.elementAt(indices[i]);
                if (children == 0) {
                    ++lineagesAdded;
                } else {
                    lineagesRemoved += children - 1;
                }
                if (++i >= times.size()) break;
                next = ((ComparableDouble)times.elementAt(indices[i])).doubleValue();
            }
            if (lineagesAdded > 0) {
                if (intervals.size() > 0 || finish - start > MULTIFURCATION_LIMIT) {
                    intervals.addElement(new Double(finish - start));
                    lineages.addElement(new Integer(numLines));
                }
                start = finish;
            }
            numLines += lineagesAdded;
            if (lineagesRemoved > 0) {
                intervals.addElement(new Double(finish - start));
                lineages.addElement(new Integer(numLines));
                start = finish;
            }
            numLines -= lineagesRemoved;
        }
        CoalescentIntervals ci = new CoalescentIntervals(intervals.size());
        i = 0;
        while (i < intervals.size()) {
            ci.setInterval(i, (Double)intervals.elementAt(i));
            ci.setNumLineages(i, (Integer)lineages.elementAt(i));
            ++i;
        }
        ci.setUnits(tree.getUnits());
        return ci;
    }

    private static void collectAllTimes(Node node, Vector times, Vector childs) {
        times.addElement(new ComparableDouble(node.getNodeHeight()));
        childs.addElement(new Integer(node.getChildCount()));
        int i = 0;
        while (i < node.getChildCount()) {
            IntervalsExtractor.collectAllTimes(node.getChild(i), times, childs);
            ++i;
        }
    }

    private static void collectInternalNodeHeights(Node node, Vector times, Vector childs) {
        if (!node.isLeaf()) {
            times.addElement(new ComparableDouble(node.getNodeHeight()));
            childs.addElement(new Integer(node.getChildCount()));
            int i = 0;
            while (i < node.getChildCount()) {
                IntervalsExtractor.collectInternalNodeHeights(node.getChild(i), times, childs);
                ++i;
            }
        }
    }
}

