/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.Serializable;
import java.util.Vector;
import pal.coalescent.CoalescentIntervals;
import pal.coalescent.DemographicModel;
import pal.math.MersenneTwisterFast;
import pal.misc.TimeOrderCharacterData;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.SimpleNode;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.util.HeapSort;

public class SerialCoalescentSimulator
implements Serializable {
    private Tree tree = null;
    private static MersenneTwisterFast rand = new MersenneTwisterFast();

    public CoalescentIntervals simulateIntervals(TimeOrderCharacterData tocd, DemographicModel model, boolean createTree) {
        Vector<Node> currentTreeNodes = null;
        Node[] nodes = null;
        double[] times = tocd.getCopyOfTimes();
        int[] indices = new int[times.length];
        HeapSort.sort(times, indices);
        if (!createTree) {
            this.tree = null;
        } else {
            nodes = new Node[times.length];
            TimeOrderCharacterData ids = tocd;
            int i = 0;
            while (i < ids.getIdCount()) {
                nodes[i] = new SimpleNode();
                nodes[i].setIdentifier(ids.getIdentifier(i));
                ++i;
            }
            currentTreeNodes = new Vector<Node>();
        }
        if (tocd.getUnits() != model.getUnits()) {
            System.err.println("Units do not match");
            System.err.println("tocd units = " + tocd.getUnits());
            System.err.println("model units = " + model.getUnits());
            return null;
        }
        int uniqueIntervals = 0;
        double currentTime = 0.0;
        int i = 0;
        while (i < times.length) {
            double time = times[indices[i]];
            if (Math.abs(time - currentTime) > 1.0E-12) {
                ++uniqueIntervals;
                currentTime = time;
            }
            ++i;
        }
        CoalescentIntervals ci = new CoalescentIntervals(uniqueIntervals + times.length - 1);
        currentTime = 0.0;
        int count = 0;
        int numLines = 0;
        int i2 = 0;
        while (i2 < times.length) {
            double nextTipTime = times[indices[i2]];
            if (Math.abs(nextTipTime - currentTime) > 1.0E-12) {
                double newTime = currentTime + model.getSimulatedInterval(numLines, currentTime);
                while (newTime < nextTipTime && numLines > 1) {
                    ci.setInterval(count, newTime - currentTime);
                    ci.setNumLineages(count, numLines);
                    if (createTree) {
                        this.addInternalNode(currentTreeNodes, numLines, newTime);
                    }
                    ++count;
                    currentTime = newTime;
                    if (--numLines <= 1) continue;
                    newTime = currentTime + model.getSimulatedInterval(numLines, currentTime);
                }
                ci.setInterval(count, newTime - currentTime);
                ci.setNumLineages(count, numLines);
                ++numLines;
                if (createTree) {
                    Node newNode = nodes[indices[i2]];
                    newNode.setNodeHeight(nextTipTime);
                    currentTreeNodes.addElement(newNode);
                }
                ++count;
                currentTime = nextTipTime;
            } else {
                ++numLines;
                if (createTree) {
                    Node newNode = nodes[indices[i2]];
                    newNode.setNodeHeight(currentTime);
                    currentTreeNodes.addElement(newNode);
                }
            }
            ++i2;
        }
        while (numLines > 1) {
            double newTime = currentTime + model.getSimulatedInterval(numLines, currentTime);
            ci.setInterval(count, newTime - currentTime);
            ci.setNumLineages(count, numLines);
            if (createTree) {
                this.addInternalNode(currentTreeNodes, numLines, newTime);
            }
            --numLines;
            ++count;
            currentTime = newTime;
        }
        if (createTree) {
            int size = currentTreeNodes.size();
            if (size > 1) {
                System.err.println("ERROR: currentTreeNodes.size() = " + size);
            }
            Node root = (Node)currentTreeNodes.elementAt(0);
            NodeUtils.heights2Lengths(root);
            this.tree = new SimpleTree(root);
            this.tree.setUnits(model.getUnits());
        }
        return ci;
    }

    private void addInternalNode(Vector currentTreeNodes, int numLines, double newTime) {
        int node1;
        if (numLines != currentTreeNodes.size()) {
            System.err.println("ERROR: Wrong number of nodes available!");
        }
        int node2 = node1 = rand.nextInt(currentTreeNodes.size());
        while (node2 == node1) {
            node2 = rand.nextInt(currentTreeNodes.size());
        }
        Node left = (Node)currentTreeNodes.elementAt(node1);
        Node right = (Node)currentTreeNodes.elementAt(node2);
        SimpleNode newNode = new SimpleNode();
        newNode.setNodeHeight(newTime);
        newNode.addChild(left);
        newNode.addChild(right);
        currentTreeNodes.removeElement(left);
        currentTreeNodes.removeElement(right);
        currentTreeNodes.addElement(newNode);
    }

    public Tree getTree() {
        return this.tree;
    }
}

