/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.Serializable;
import pal.alignment.SitePattern;
import pal.distance.DistanceMatrix;
import pal.distance.PairwiseDistance;
import pal.substmodel.SubstitutionModel;

public class AlignmentDistanceMatrix
extends DistanceMatrix
implements Serializable {
    private PairwiseDistance pwd;
    private double progress_ = -1.0;

    public AlignmentDistanceMatrix(SitePattern sp) {
        this(sp, null, true);
    }

    public AlignmentDistanceMatrix(SitePattern sp, boolean immediateCompute) {
        this(sp, null, immediateCompute);
    }

    public AlignmentDistanceMatrix(SitePattern sp, SubstitutionModel m) {
        this(sp, m, true);
    }

    protected AlignmentDistanceMatrix(SitePattern sp, SubstitutionModel m, boolean immediateCompute) {
        this.numSeqs = sp.getSequenceCount();
        this.idGroup = sp;
        this.distance = new double[this.numSeqs][this.numSeqs];
        this.pwd = m != null ? new PairwiseDistance(sp, m) : new PairwiseDistance(sp);
        if (immediateCompute) {
            this.computeDistances();
        }
    }

    public void recompute(SubstitutionModel m) {
        this.pwd.updateModel(m);
        this.computeDistances();
    }

    public void recompute(SitePattern sp) {
        this.pwd.updateSitePattern(sp);
        this.computeDistances();
    }

    private void computeDistances() {
        int i = 0;
        while (i < this.numSeqs) {
            this.distance[i][i] = 0.0;
            int j = i + 1;
            while (j < this.numSeqs) {
                this.progress_ = (double)(2 * (i * this.numSeqs + j)) / (double)(this.numSeqs * this.numSeqs);
                this.distance[i][j] = this.pwd.getDistance(i, j);
                this.distance[j][i] = this.distance[i][j];
                ++j;
            }
            ++i;
        }
        this.progress_ = -1.0;
    }

    public final double getProgress() {
        return this.progress_;
    }
}

