/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import pal.io.FormattedOutput;
import pal.misc.IdGroup;
import pal.misc.Identifier;

public class DistanceMatrix
implements Serializable,
IdGroup {
    static final long serialVersionUID = 4725925229860707633L;
    public int numSeqs = 0;
    public IdGroup idGroup;
    public double[][] distance = null;
    FormattedOutput format;

    public DistanceMatrix() {
        this.format = FormattedOutput.getInstance();
    }

    public DistanceMatrix(double[][] distance, IdGroup idGroup) {
        this.distance = distance;
        this.idGroup = idGroup;
        this.numSeqs = distance.length;
        this.format = FormattedOutput.getInstance();
    }

    public DistanceMatrix(DistanceMatrix dm) {
        this.distance = new double[dm.getSize()][dm.getSize()];
        int i = 0;
        while (i < dm.getSize()) {
            int j = 0;
            while (j < dm.getSize()) {
                this.distance[i][j] = dm.distance[i][j];
                ++j;
            }
            ++i;
        }
        this.numSeqs = this.distance.length;
        this.format = dm.format;
        this.idGroup = dm.getIdGroup();
    }

    public DistanceMatrix(DistanceMatrix dm, IdGroup subset) {
        this.distance = new double[subset.getIdCount()][subset.getIdCount()];
        int i = 0;
        while (i < this.distance.length) {
            int index1 = dm.whichIdNumber(subset.getIdentifier(i).getName());
            int j = 0;
            while (j < i) {
                int index2 = dm.whichIdNumber(subset.getIdentifier(j).getName());
                this.distance[i][j] = dm.distance[index1][index2];
                this.distance[j][i] = this.distance[i][j];
                ++j;
            }
            ++i;
        }
        this.numSeqs = this.distance.length;
        this.format = dm.format;
        this.idGroup = subset;
    }

    public void printPHYLIP(PrintWriter out) {
        out.println("  " + this.numSeqs);
        int i = 0;
        while (i < this.numSeqs) {
            this.format.displayLabel(out, this.idGroup.getIdentifier(i).getName(), 10);
            out.print("      ");
            int j = 0;
            while (j < this.numSeqs) {
                if (j % 6 == 0 && j != 0) {
                    out.println();
                    out.print("                ");
                }
                out.print("  ");
                this.format.displayDecimal(out, this.distance[i][j], 5);
                ++j;
            }
            out.println();
            ++i;
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.printPHYLIP(new PrintWriter(sw));
        return sw.toString();
    }

    public double squaredDistance(DistanceMatrix mat, boolean weighted) {
        double sum = 0.0;
        int i = 0;
        while (i < this.numSeqs - 1) {
            int j = i + 1;
            while (j < this.numSeqs) {
                double diff = this.distance[i][j] - mat.distance[i][j];
                double weight = weighted ? 1.0 / (this.distance[i][j] * this.distance[i][j]) : 1.0;
                sum += weight * diff * diff;
                ++j;
            }
            ++i;
        }
        return 2.0 * sum;
    }

    public double absoluteDistance(DistanceMatrix mat) {
        double sum = 0.0;
        int i = 0;
        while (i < this.numSeqs - 1) {
            int j = i + 1;
            while (j < this.numSeqs) {
                double diff = Math.abs(this.distance[i][j] - mat.distance[i][j]);
                sum += diff;
                ++j;
            }
            ++i;
        }
        return 2.0 * sum;
    }

    public int getSize() {
        return this.distance.length;
    }

    public double[][] getDistances() {
        return this.distance;
    }

    public void setDistance(int i, int j, double dist) {
        double d = dist;
        this.distance[j][i] = d;
        this.distance[i][j] = d;
    }

    public void addDistance(int i, int j, double delta) {
        double[] dArray = this.distance[i];
        int n = j;
        dArray[n] = dArray[n] + delta;
        double[] dArray2 = this.distance[j];
        int n2 = i;
        dArray2[n2] = dArray2[n2] + delta;
    }

    public double meanDistance() {
        double dist = 0.0;
        int count = 0;
        int i = 0;
        while (i < this.distance.length) {
            int j = 0;
            while (j < this.distance[i].length) {
                if (i != j) {
                    dist += this.distance[i][j];
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return dist / (double)count;
    }

    public Identifier getIdentifier(int i) {
        return this.idGroup.getIdentifier(i);
    }

    public void setIdentifier(int i, Identifier ident) {
        this.idGroup.setIdentifier(i, ident);
    }

    public int getIdCount() {
        return this.idGroup.getIdCount();
    }

    public int whichIdNumber(String name) {
        return this.idGroup.whichIdNumber(name);
    }

    public IdGroup getIdGroup() {
        return this.idGroup;
    }

    public boolean isSymmetric() {
        int i = 0;
        while (i < this.distance.length) {
            if (this.distance[i][i] != 0.0) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.distance.length - 1) {
            int j = i2 + 1;
            while (j < this.distance.length) {
                if (this.distance[i2][j] != this.distance[j][i2]) {
                    return false;
                }
                ++j;
            }
            ++i2;
        }
        return true;
    }

    static {
        serialVersionUID = 4725925229860707633L;
    }
}

