/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import pal.alignment.Alignment;
import pal.alignment.SitePattern;
import pal.distance.AlignmentDistanceMatrix;
import pal.distance.DistanceMatrix;

public class JukesCantorDistanceMatrix
extends DistanceMatrix {
    private double[][] obsDistance;
    private double const1;
    private double const2;

    public JukesCantorDistanceMatrix(DistanceMatrix dist) {
        this(dist, 4);
    }

    public JukesCantorDistanceMatrix(DistanceMatrix dist, int numStates) {
        this.numSeqs = dist.numSeqs;
        this.idGroup = dist.getIdGroup();
        this.distance = new double[this.numSeqs][this.numSeqs];
        this.obsDistance = dist.distance;
        double n = numStates;
        this.const1 = (n - 1.0) / n;
        this.const2 = n / (n - 1.0);
        this.computeDistances();
    }

    public JukesCantorDistanceMatrix(Alignment alignment) {
        this(new SitePattern(alignment));
    }

    public JukesCantorDistanceMatrix(SitePattern sitePattern) {
        this((DistanceMatrix)new AlignmentDistanceMatrix(sitePattern), sitePattern.getDataType().getNumStates());
    }

    private void computeDistances() {
        int i = 0;
        while (i < this.numSeqs - 1) {
            this.distance[i][i] = 0.0;
            int j = i + 1;
            while (j < this.numSeqs) {
                double d = this.jccorrection(this.obsDistance[i][j]);
                this.distance[j][i] = d;
                this.distance[i][j] = d;
                ++j;
            }
            ++i;
        }
    }

    private double jccorrection(double obsdist) {
        if (obsdist == 0.0) {
            return 0.0;
        }
        if (obsdist >= this.const1) {
            return 100.0;
        }
        double expDist = -this.const1 * Math.log(1.0 - this.const2 * obsdist);
        if (expDist < 100.0) {
            return expDist;
        }
        return 100.0;
    }
}

