/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.Serializable;
import pal.alignment.SitePattern;
import pal.distance.SequencePairLikelihood;
import pal.math.UnivariateMinimum;
import pal.substmodel.SubstitutionModel;

public class PairwiseDistance
implements Serializable {
    public double distance;
    public double distanceSE;
    private int numSites;
    private int numPatterns;
    private int numStates;
    private int[] weight;
    private double jcratio;
    private boolean modelBased;
    private SitePattern sitePattern;
    private UnivariateMinimum um;
    private SequencePairLikelihood of;

    public PairwiseDistance(SitePattern sp) {
        this.updateSitePattern(sp);
    }

    public PairwiseDistance(SitePattern sp, SubstitutionModel m) {
        this(sp);
        this.modelBased = true;
        this.of = new SequencePairLikelihood(sp, m);
        this.um = new UnivariateMinimum();
    }

    public void updateModel(SubstitutionModel m) {
        if (this.of == null) {
            this.modelBased = true;
            this.of = new SequencePairLikelihood(this.sitePattern, m);
            this.um = new UnivariateMinimum();
        } else {
            this.of.updateModel(m);
        }
    }

    public void updateSitePattern(SitePattern sp) {
        this.sitePattern = sp;
        this.numSites = sp.getSiteCount();
        this.numPatterns = sp.numPatterns;
        this.numStates = sp.getDataType().getNumStates();
        this.weight = sp.weight;
        this.jcratio = ((double)this.numStates - 1.0) / (double)this.numStates;
        if (this.modelBased) {
            this.of.updateSitePattern(sp);
        }
    }

    public double getDistance(int s1, int s2) {
        return this.getDistance(this.sitePattern.pattern[s1], this.sitePattern.pattern[s2]);
    }

    public double getDistance(byte[] s1, byte[] s2) {
        double f2x;
        double dist = this.getObservedDistance(s1, s2);
        if (this.modelBased && dist != 0.0) {
            double start = 1.0 - dist / this.jcratio;
            start = start > 0.0 ? -this.jcratio * Math.log(start) : dist;
            this.of.setSequences(s1, s2);
            dist = start > 100.0 || start < 1.0E-9 ? this.um.findMinimum(this.of, 6) : this.um.findMinimum(start, this.of, 6);
        }
        this.distanceSE = this.modelBased ? (1.0E-4 < (f2x = this.um.f2minx) ? Math.sqrt(1.0 / f2x) : 100.0) : 0.0;
        this.distance = dist;
        return dist;
    }

    private boolean isDifferent(int s1, int s2) {
        if (s1 == this.numStates || s2 == this.numStates) {
            return false;
        }
        return s1 != s2;
    }

    private double getObservedDistance(byte[] seqPat1, byte[] seqPat2) {
        int diff = 0;
        int i = 0;
        while (i < this.numPatterns) {
            if (this.isDifferent(seqPat1[i], seqPat2[i])) {
                diff += this.weight[i];
            }
            ++i;
        }
        return (double)diff / (double)this.numSites;
    }
}

