/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import pal.alignment.SitePattern;
import pal.math.UnivariateFunction;
import pal.substmodel.RateMatrix;
import pal.substmodel.SubstitutionModel;

public class SequencePairLikelihood
implements UnivariateFunction {
    private SubstitutionModel model;
    private RateMatrix rateMatrix;
    private SitePattern sitePattern;
    private int numPatterns;
    private int numSites;
    private int numStates;
    private int numRates;
    private int[] weight;
    private double[] rateProb;
    private byte[] seqPat1;
    private byte[] seqPat2;

    public SequencePairLikelihood(SitePattern sp, SubstitutionModel m) {
        this.updateSitePattern(sp);
        this.updateModel(m);
    }

    public void updateModel(SubstitutionModel m) {
        this.model = m;
        this.numRates = this.model.getRateDistribution().numRates;
        this.rateProb = this.model.getRateDistribution().probability;
        this.rateMatrix = this.model.getRateMatrix();
    }

    public void updateSitePattern(SitePattern sp) {
        this.sitePattern = sp;
        this.numPatterns = sp.numPatterns;
        this.numSites = sp.getSiteCount();
        this.numStates = sp.getDataType().getNumStates();
        this.weight = sp.weight;
    }

    public void setSequences(int s1, int s2) {
        this.setSequences(this.sitePattern.pattern[s1], this.sitePattern.pattern[s2]);
    }

    public void setSequences(byte[] s1, byte[] s2) {
        this.seqPat1 = s1;
        this.seqPat2 = s2;
    }

    public double evaluate(double arc) {
        this.model.setDistance(arc);
        double loglkl = 0.0;
        int i = 0;
        while (i < this.numPatterns) {
            double sumprob = 0.0;
            int r = 0;
            while (r < this.numRates) {
                sumprob += this.rateProb[r] * this.probConfig(r, this.seqPat1[i], this.seqPat2[i]);
                ++r;
            }
            loglkl += (double)this.weight[i] * Math.log(sumprob);
            ++i;
        }
        return -loglkl;
    }

    public double getLowerBound() {
        return 1.0E-9;
    }

    public double getUpperBound() {
        return 100.0;
    }

    private double probConfig(int r, int i, int j) {
        double p = i == this.numStates && j == this.numStates ? 1.0 : (i == this.numStates ? this.rateMatrix.getEquilibriumFrequency(j) : (j == this.numStates ? this.rateMatrix.getEquilibriumFrequency(i) : this.rateMatrix.getEquilibriumFrequency(i) * this.model.transProb(r, i, j)));
        return p;
    }
}

