/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.coalescent.CoalescentIntervals;
import pal.coalescent.DemographicModel;
import pal.math.DifferentialEvolution;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.NumericalDerivative;

public class DemographicValue
implements MultivariateFunction {
    public double logL;
    private int numParams;
    protected CoalescentIntervals intervals;
    protected DemographicModel model;
    private MultivariateMinimum mvm;

    public void setDemographicModel(DemographicModel m) {
        this.model = m;
        this.numParams = this.model.getNumParameters();
        this.mvm = new DifferentialEvolution(this.numParams, 20 * this.numParams);
    }

    public DemographicModel getDemographicModel() {
        return this.model;
    }

    public CoalescentIntervals getCoalescentIntervals() {
        return this.intervals;
    }

    public void setCoalescentIntervals(CoalescentIntervals ci) {
        this.intervals = ci;
    }

    public double compute() {
        this.computeLogLikelihood();
        return -this.logL;
    }

    public double optimize() {
        return this.optimize(this.mvm);
    }

    public double optimize(MultivariateMinimum givenMvm) {
        double[] estimate = new double[this.numParams];
        int i = 0;
        while (i < this.numParams) {
            estimate[i] = this.model.getParameter(i);
            ++i;
        }
        givenMvm.findMinimum(this, estimate, 6, 6);
        double[] estimateSE = new double[this.numParams];
        estimateSE = NumericalDerivative.diagonalHessian(this, estimate);
        int i2 = 0;
        while (i2 < this.numParams) {
            estimateSE[i2] = Math.sqrt(Math.abs(1.0 / estimateSE[i2]));
            this.model.setParameterSE(estimateSE[i2], i2);
            ++i2;
        }
        this.evaluate(estimate);
        this.model.setLogL(this.logL);
        return -this.logL;
    }

    public double evaluate(double[] params) {
        int i = 0;
        while (i < this.numParams) {
            this.model.setParameter(params[i], i);
            ++i;
        }
        return this.compute();
    }

    public int getNumArguments() {
        return this.numParams;
    }

    public double getLowerBound(int n) {
        return this.model.getLowerLimit(n);
    }

    public double getUpperBound(int n) {
        return this.model.getUpperLimit(n);
    }

    protected void computeLogLikelihood() {
        this.logL = this.intervals.computeLogLikelihood(this.model);
    }
}

