/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.alignment.SitePattern;
import pal.eval.LikelihoodValue;
import pal.math.UnivariateFunction;
import pal.substmodel.SubstitutionModel;
import pal.tree.Node;

class NodeLikelihood
implements UnivariateFunction {
    private LikelihoodValue lv;
    private double[][][] partial1;
    private double[][][] partial2;
    private byte[] seq;
    private int numStates;
    private int numRates;
    private int numPatterns;
    private double[] frequency;
    private double[] rprob;
    private SitePattern sitePattern;
    private SubstitutionModel model;
    private double minHeight;
    private double maxHeight;
    private Node center;
    private Node firstBranch;
    private Node lastBranch;

    public NodeLikelihood(LikelihoodValue lv) {
        this.lv = lv;
        this.update();
    }

    public void update() {
        this.model = this.lv.getModel();
        this.numPatterns = this.lv.numPatterns;
        this.numRates = this.lv.numRates;
        this.numStates = this.lv.numStates;
        this.frequency = this.lv.frequency;
        this.rprob = this.lv.rprob;
        this.sitePattern = this.lv.sitePattern;
    }

    public void setBranch(Node branch, double min, double max) {
        this.center = branch;
        if (this.center.isLeaf()) {
            throw new IllegalArgumentException();
        }
        if (this.center.isRoot()) {
            this.firstBranch = this.center.getChild(0);
            this.lastBranch = this.center.getChild(this.center.getChildCount() - 1);
            this.partial1 = this.lv.getPartial(this.firstBranch);
            this.partial2 = this.lv.getPartial(this.lastBranch);
        } else {
            this.partial1 = this.lv.getPartial(this.center);
            this.partial2 = this.lv.getPartial(this.lv.getNextBranch(this.center, this.center.getParent()));
        }
        this.minHeight = min;
        this.maxHeight = max;
    }

    public double evaluate(double h) {
        this.center.setNodeHeight(h);
        int i = 0;
        while (i < this.center.getChildCount()) {
            Node child = this.center.getChild(i);
            child.setBranchLength(h - child.getNodeHeight());
            ++i;
        }
        int i2 = 0;
        while (i2 < this.center.getChildCount()) {
            Node child = this.center.getChild(i2);
            if (child.isLeaf()) {
                this.lv.partialsExternal(child);
            } else {
                this.lv.partialsInternal(child, child);
            }
            ++i2;
        }
        if (this.center.isRoot()) {
            this.lv.productPartials(this.lastBranch, this.center);
        } else {
            this.lv.productPartials(this.center, this.center);
            this.center.setBranchLength(this.maxHeight - h);
            this.lv.partialsInternal(this.center, this.center);
        }
        this.lv.logL = 0.0;
        int l = 0;
        while (l < this.numPatterns) {
            double rsum = 0.0;
            int r = 0;
            while (r < this.numRates) {
                double[] p1 = this.partial1[l][r];
                double[] p2 = this.partial2[l][r];
                double sum = 0.0;
                int d = 0;
                while (d < this.numStates) {
                    sum += this.frequency[d] * p1[d] * p2[d];
                    ++d;
                }
                rsum += (sum *= this.rprob[r]);
                ++r;
            }
            this.lv.siteLogL[l] = Math.log(rsum);
            this.lv.logL += this.lv.siteLogL[l] * (double)this.sitePattern.weight[l];
            ++l;
        }
        return -this.lv.logL;
    }

    public double getLowerBound() {
        return this.minHeight;
    }

    public double getUpperBound() {
        return this.maxHeight;
    }
}

