/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import pal.gui.CircularGraphics;
import pal.gui.LayoutTracker;
import pal.gui.PositionedNode;
import pal.gui.TreePainter;
import pal.io.FormattedOutput;
import pal.tree.NodeUtils;
import pal.tree.Tree;

public class TreePainterCircular
extends TreePainter {
    public static final int RIGHTBORDER = 75;
    public static final int LEFTBORDER = 10;
    public static final int TOPBORDER = 20;
    public static final int BOTTOMBORDER = 30;
    static final int SYMBOL_SIZE = 8;
    public static final int FONT_SIZE = 9;
    public static final int YSPACER = 20;
    public static final int XSPACER = 10;
    double maxAngle_;
    double maxRadius_;

    public TreePainterCircular(Tree toDisplay, String title, boolean showTitle) {
        super(toDisplay, title, showTitle);
        this.maxRadius_ = this.treeNode.getNodeHeight();
        this.maxAngle_ = NodeUtils.getLeafCount(this.treeNode);
    }

    public Dimension getPreferredSize() {
        return new Dimension(185, 150);
    }

    protected void paint(PositionedNode node, CircularGraphics cg) {
        cg.setColor(TreePainter.FOREGROUND);
        double angle = node.x;
        double radius = node.getNodeHeight();
        if (node.hasChildren()) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.paintLeafBranch(node, (PositionedNode)node.getChild(i), cg);
                ++i;
            }
            int i2 = 0;
            while (i2 < node.getChildCount()) {
                this.paint((PositionedNode)node.getChild(i2), cg);
                ++i2;
            }
            int bootStrapValue = this.getBootstrapValue(node);
            if (bootStrapValue >= 50) {
                cg.setColor(TreePainter.BOOTSTRAP_SUPPORT_COLOUR);
                cg.drawString(bootStrapValue + "", angle, radius, 10);
            }
        } else {
            if (this.maxLeafTime > 0.0 && this.isUsingColor()) {
                cg.setColor(Color.getHSBColor((float)(this.maxLeafTime - radius) / (float)this.maxLeafTime, 1.0f, 1.0f));
            } else {
                cg.setColor(TreePainter.NORMAL_LABEL_COLOR);
            }
            if (this.isUsingColor()) {
                cg.fillPoint(angle, radius, 2);
            }
            if (this.isUsingSymbols() && this.getTimeOrderCharacterData() != null) {
                cg.drawSymbol(angle, radius, 10, 8, this.getTimeOrderCharacterData().getTimeOrdinal(this.getTimeOrderCharacterData().whichIdNumber(node.getIdentifier().getName())));
            } else if (this.isUsingColor()) {
                cg.drawString(node.getIdentifier().getName(), angle, radius, 10);
                if (node.isHighlighted()) {
                    cg.setColor(Color.red);
                    cg.circleString(node.getIdentifier().getName(), angle, radius, 10);
                }
            } else {
                if (node.isHighlighted()) {
                    cg.setColor(Color.red);
                }
                cg.drawString(node.getIdentifier().getName(), angle, radius, 10);
            }
        }
    }

    private void paintLeafBranch(PositionedNode parentNode, PositionedNode childNode, CircularGraphics g) {
        g.drawArc(parentNode.x, childNode.x, parentNode.getNodeHeight());
        g.drawLineDegreeAlign(childNode.x, childNode.getNodeHeight(), parentNode.getNodeHeight());
        if (this.isShowingNodeHeights()) {
            String label = FormattedOutput.getInstance().getDecimalString(childNode.getNodeHeight(), 4);
            g.drawString(label, childNode.x, childNode.getNodeHeight(), 10);
        }
    }

    public void paint(Graphics g, int displayWidth, int displayHeight) {
        this.paint(g, displayWidth, displayHeight, false, null);
    }

    public void paint(Graphics g, int displayWidth, int displayHeight, LayoutTracker lt) {
        this.paint(g, displayWidth, displayHeight, false, lt);
    }

    public final void paint(Graphics g, int displayWidth, int displayHeight, boolean invert) {
        this.paint(g, displayWidth, displayHeight, invert, null);
    }

    public final void paint(Graphics g, int displayWidth, int displayHeight, boolean invert, LayoutTracker lt) {
        CircularGraphics cg = new CircularGraphics(g, this.maxAngle_, this.maxRadius_, 10, 20, displayWidth - 10 - 75, displayHeight - 20 - 30, invert);
        cg.setFont(new Font("Times", 0, 9));
        g.setColor(TreePainter.BACKGROUND);
        g.fillRect(0, 0, displayWidth, displayHeight);
        this.paint(this.treeNode, cg);
        this.doTitle(g, 10, 12);
    }

    static {
        RIGHTBORDER = 75;
        LEFTBORDER = 10;
        TOPBORDER = 20;
        BOTTOMBORDER = 30;
        SYMBOL_SIZE = 8;
        FONT_SIZE = 9;
        YSPACER = 20;
        XSPACER = 10;
    }
}

