/*
 * Decompiled with CFR 0.152.
 */
package pal.io;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import pal.io.SFStringInfo;

public class FormattedOutput
implements Serializable {
    private static FormattedOutput singleton = null;
    private NumberFormat nf = NumberFormat.getInstance(Locale.UK);

    public static synchronized FormattedOutput getInstance() {
        if (singleton == null) {
            singleton = new FormattedOutput();
        }
        return singleton;
    }

    public int displayDecimal(PrintWriter out, double number, int width) {
        String s = this.getDecimalString(number, width);
        out.print(s);
        return s.length();
    }

    public synchronized String getDecimalString(double number, int width) {
        this.nf.setMinimumFractionDigits(width);
        this.nf.setMaximumFractionDigits(width);
        return this.nf.format(number);
    }

    private static final double round(double number, int sf) {
        double decimals = Math.floor(Math.log(number) / Math.log(10.0));
        double power = Math.pow(10.0, decimals - (double)sf + 1.0);
        number /= power;
        number = Math.round(number);
        return number *= power;
    }

    private SFStringInfo getSFStringInfo(String buffer, int sf, boolean includeRightZeros, boolean previousCarry) {
        char[] b2 = new char[includeRightZeros ? buffer.length() : Math.min(sf, buffer.length())];
        boolean carry = sf >= buffer.length() ? previousCarry : buffer.charAt(sf) >= '5';
        int i = b2.length - 1;
        while (i >= 0) {
            if (i < sf) {
                b2[i] = buffer.charAt(i);
                if (carry) {
                    if (b2[i] == '9') {
                        b2[i] = 48;
                    } else {
                        int n = i;
                        b2[n] = (char)(b2[n] + '\u0001');
                        carry = false;
                    }
                }
            } else {
                carry = buffer.charAt(i) >= '5';
                b2[i] = 48;
            }
            --i;
        }
        return new SFStringInfo(new String(b2), carry);
    }

    public String getSFString(double number, int sf) {
        String s = number + "";
        String preFullStop = null;
        String postFullStop = null;
        String postE = null;
        int fullStopIndex = s.indexOf(46);
        int eIndex = s.indexOf(101);
        if (eIndex < 0) {
            eIndex = s.indexOf(69);
        }
        if (eIndex >= 0) {
            postE = s.substring(eIndex + 1);
        }
        eIndex = s.length();
        if (fullStopIndex >= 0) {
            postFullStop = s.substring(fullStopIndex + 1, eIndex);
        } else {
            fullStopIndex = eIndex;
        }
        preFullStop = s.substring(0, fullStopIndex);
        SFStringInfo postFSI = null;
        boolean postCarry = false;
        if (postFullStop != null) {
            int postSF = sf - preFullStop.length();
            if (postSF > 0) {
                postFSI = this.getSFStringInfo(postFullStop, postSF, false, false);
                postCarry = postFSI.carry;
            } else {
                postCarry = postFullStop.charAt(0) >= '5';
            }
        }
        SFStringInfo preFSI = this.getSFStringInfo(preFullStop, sf, true, postCarry);
        if (preFSI.carry) {
            preFSI.string = "1" + preFSI.string;
        }
        String b = postFSI != null ? preFSI.string + "." + postFSI.string : preFSI.string;
        if (postE != null) {
            b = b + 'e' + postE;
        }
        while (b.charAt(b.length() - 1) == '0') {
            b = b.substring(0, b.length() - 1);
        }
        if (b.charAt(b.length() - 1) == '.') {
            b = b.substring(0, b.length() - 1);
        }
        return b;
    }

    public void displayLabel(PrintWriter out, String label, int width) {
        int len = label.length();
        if (len == width) {
            out.print(label);
        } else if (len < width) {
            out.print(label);
            this.multiplePrint(out, ' ', width - len);
        } else {
            int i = 0;
            while (i < width) {
                out.print(label.charAt(i));
                ++i;
            }
        }
    }

    public void displayInteger(PrintWriter out, int num, int maxNum) {
        int lenMaxNum;
        int lenNum = Integer.toString(num).length();
        if (lenNum < (lenMaxNum = Integer.toString(maxNum).length())) {
            this.multiplePrint(out, ' ', lenMaxNum - lenNum);
        }
        out.print(num);
    }

    public void displayIntegerWhite(PrintWriter out, int maxNum) {
        int lenMaxNum = Integer.toString(maxNum).length();
        this.multiplePrint(out, ' ', lenMaxNum);
    }

    public void multiplePrint(PrintWriter out, char c, int num) {
        int i = 0;
        while (i < num) {
            out.print(c);
            ++i;
        }
    }

    public static String space(int size, char c) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < size) {
            sb.append(c);
            ++i;
        }
        return new String(sb);
    }

    private FormattedOutput() {
        this.nf.setGroupingUsed(false);
    }
}

