/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;

public class MathUtils {
    public static MersenneTwisterFast random = new MersenneTwisterFast();

    public static final double[] getNormalized(double[] array) {
        double[] newArray = new double[array.length];
        double total = MathUtils.getTotal(array);
        int i = 0;
        while (i < array.length) {
            newArray[i] = array[i] / total;
            ++i;
        }
        return newArray;
    }

    public static final double getTotal(double[] array, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < array.length) {
            total += array[i];
            ++i;
        }
        return total;
    }

    public static final double getTotal(double[] array) {
        return MathUtils.getTotal(array, 0, array.length);
    }

    public static final double[] getRandomArguments(MultivariateFunction mf) {
        double[] values = new double[mf.getNumArguments()];
        int i = 0;
        while (i < values.length) {
            double min = mf.getLowerBound(i);
            double max = mf.getUpperBound(i);
            values[i] = (max - min) * MersenneTwisterFast.getNextDouble() + min;
            ++i;
        }
        return values;
    }
}

