/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalLineFunction;
import pal.math.UnivariateMinimum;

public class OrthogonalSearch
extends MultivariateMinimum {
    private UnivariateMinimum um = new UnivariateMinimum();
    private int numArgs;

    public void optimize(MultivariateFunction f, double[] xvec, double tolfx, double tolx) {
        this.numArgs = f.getNumArguments();
        this.numFun = 1;
        double fx = f.evaluate(xvec);
        this.stopCondition(fx, xvec, tolfx, tolx, true);
        OrthogonalLineFunction olf = new OrthogonalLineFunction(f);
        olf.setAllArguments(xvec);
        do {
            int i = 0;
            while (i < this.numArgs) {
                olf.selectArgument(i);
                xvec[i] = this.um.optimize(olf, tolx);
                olf.setArgument(xvec[i]);
                this.numFun += this.um.numFun;
                ++i;
            }
        } while (!this.stopCondition(fx = this.um.fminx, xvec, tolfx, tolx, false) && (this.maxFun <= 0 || this.numFun <= this.maxFun) && this.numArgs != 1);
    }
}

