/*
 * Decompiled with CFR 0.152.
 */
package pal.mep;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.io.OutputTarget;
import pal.mep.MutationRateModel;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.Summarizable;

public class ConstantMutationRate
extends MutationRateModel
implements Report,
Summarizable,
Parameterized,
Serializable {
    private static final String[] CP_SUMMARY_TYPES = new String[]{"mu", "muSE"};
    private double mu;
    private double muSE;

    public ConstantMutationRate(int units) {
        this.setUnits(units);
        this.mu = this.getDefaultValue(0);
    }

    public ConstantMutationRate(double rate, int units) {
        this.mu = rate;
        this.setUnits(units);
    }

    public Object clone() {
        return new ConstantMutationRate(this.getMu(), this.getUnits());
    }

    public String[] getSummaryTypes() {
        return CP_SUMMARY_TYPES;
    }

    public double getSummaryValue(int summaryType) {
        switch (summaryType) {
            case 0: {
                return this.mu;
            }
            case 1: {
                return this.muSE;
            }
        }
        throw new RuntimeException("Assertion error: unknown summary type :" + summaryType);
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double m) {
        this.mu = m;
    }

    public final double getMutationRate(double t) {
        return this.mu;
    }

    public final double getExpectedSubstitutions(double t) {
        return this.mu * t;
    }

    public final double getTime(double expectedSubs) {
        return expectedSubs / this.mu;
    }

    public final void scale(double scale) {
        this.mu *= scale;
    }

    public int getNumParameters() {
        return 1;
    }

    public double getParameter(int k) {
        return this.mu;
    }

    public double getUpperLimit(int k) {
        return 1.0E12;
    }

    public double getLowerLimit(int k) {
        return 1.0E-12;
    }

    public double getDefaultValue(int k) {
        if (this.getUnits() == 1) {
            return 1.0E-6;
        }
        return 1.0E-6;
    }

    public void setParameter(double value, int k) {
        this.mu = value;
    }

    public void setParameterSE(double value, int k) {
        this.muSE = value;
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Mutation rate model: constant mutation rate ");
        out.println("Function: mu(t) = mu");
        out.print("Unit of time: ");
        if (this.getUnits() == 1) {
            out.print("generations");
        } else {
            out.print("expected substitutions");
        }
        out.println();
        out.println();
        out.println("Parameters of function:");
        out.print(" mutation rate: ");
        this.fo.displayDecimal(out, this.mu, 6);
        out.println();
    }

    public String toSingleLine() {
        return "mu\t" + this.mu;
    }
}

