/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import pal.misc.ExternalParameterListener;
import pal.misc.ParameterEvent;
import pal.misc.Parameterized;

public class ParameterizedDouble
implements Parameterized,
Serializable {
    private double defaultValue_;
    private double currentValue_;
    private double minimumValue_;
    private double maximumValue_;
    private double se_;
    private Vector listeners_ = new Vector();

    public ParameterizedDouble(double defaultValue, double minimumValue, double maximumValue) {
        this.currentValue_ = defaultValue;
        this.defaultValue_ = defaultValue;
        this.minimumValue_ = minimumValue;
        this.maximumValue_ = maximumValue;
    }

    public final void setValue(double value) {
        this.currentValue_ = value;
        this.fireValueChangedEvent();
    }

    public final double getValue() {
        return this.currentValue_;
    }

    public final void setMaximumValue(double value) {
        this.maximumValue_ = value;
    }

    public final void setMinimumValue(double value) {
        this.minimumValue_ = value;
    }

    private final void fireValueChangedEvent() {
        ParameterEvent pe = new ParameterEvent(this);
        Enumeration e = this.listeners_.elements();
        while (e.hasMoreElements()) {
            ((ExternalParameterListener)e.nextElement()).parameterChanged(pe);
        }
    }

    public final void addExternalParameterListener(ExternalParameterListener l) {
        if (!this.listeners_.contains(l)) {
            this.listeners_.addElement(l);
        }
    }

    public final void removeExternalParameterListener(ExternalParameterListener l) {
        this.listeners_.removeElement(l);
    }

    public final double getLowerLimit() {
        return this.minimumValue_;
    }

    public final double getUpperLimit() {
        return this.maximumValue_;
    }

    public final double getDefaultValue() {
        return this.defaultValue_;
    }

    public final double getSE() {
        return this.se_;
    }

    public final void setSE(double value) {
        this.se_ = value;
    }

    public int getNumParameters() {
        return 1;
    }

    public final void setParameter(double param, int n) {
        this.setValue(param);
    }

    public double getParameter(int n) {
        return this.currentValue_;
    }

    public void setParameterSE(double paramSE, int n) {
        this.se_ = paramSE;
    }

    public double getLowerLimit(int n) {
        return this.minimumValue_;
    }

    public double getUpperLimit(int n) {
        return this.maximumValue_;
    }

    public double getDefaultValue(int n) {
        return this.defaultValue_;
    }

    public String toString() {
        return "Parameterized Double (current,default,min,max):" + this.currentValue_ + ", " + this.defaultValue_ + ", " + this.minimumValue_ + ", " + this.maximumValue_ + ", ";
    }
}

