/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pal.math.MersenneTwisterFast;
import pal.misc.BranchLimits;
import pal.misc.IdGenerator;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.util.HeapSort;

public class TimeOrderCharacterData
implements Serializable,
BranchLimits,
IdGroup {
    protected int[] timeOrdinals = null;
    protected double[] times = null;
    protected IdGroup taxa;
    protected int units = 1;
    private String name = "Time/order character data";
    private static final long serialVersionUID = 7672390862755080486L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.timeOrdinals);
        out.writeObject(this.times);
        out.writeObject(this.taxa);
        out.writeInt(this.units);
        out.writeObject(this.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.timeOrdinals = (int[])in.readObject();
        this.times = (double[])in.readObject();
        this.taxa = (IdGroup)in.readObject();
        this.units = in.readInt();
        this.name = (String)in.readObject();
    }

    protected TimeOrderCharacterData() {
    }

    public TimeOrderCharacterData(IdGroup taxa, int units) {
        this.taxa = taxa;
    }

    public TimeOrderCharacterData(int numSeqsPerSample, int numSamples, double timeBetweenSamples, int units) {
        int n = numSeqsPerSample * numSamples;
        this.taxa = IdGenerator.createIdGroup(n);
        this.timeOrdinals = new int[this.taxa.getIdCount()];
        this.times = new double[this.taxa.getIdCount()];
        int index = 0;
        int i = 0;
        while (i < numSamples) {
            int j = 0;
            while (j < numSeqsPerSample) {
                this.times[index] = timeBetweenSamples * (double)i;
                this.timeOrdinals[index] = i;
                ++index;
                ++j;
            }
            ++i;
        }
        this.units = units;
    }

    public static TimeOrderCharacterData clone(TimeOrderCharacterData tocd) {
        return tocd.subset(tocd);
    }

    public TimeOrderCharacterData subset(IdGroup staxa) {
        TimeOrderCharacterData subset = new TimeOrderCharacterData(staxa, this.getUnits());
        subset.timeOrdinals = new int[staxa.getIdCount()];
        if (this.hasTimes()) {
            subset.times = new double[staxa.getIdCount()];
        }
        int i = 0;
        while (i < subset.timeOrdinals.length) {
            int index = this.taxa.whichIdNumber(staxa.getIdentifier(i).getName());
            subset.timeOrdinals[i] = this.timeOrdinals[index];
            if (this.hasTimes()) {
                subset.times[i] = this.times[index];
            }
            ++i;
        }
        return subset;
    }

    public int getUnits() {
        return this.units;
    }

    public void setTimes(double[] times, int units) {
        this.setTimes(times, units, true);
    }

    public void setTimes(double[] times, int units, boolean recalculateOrdinals) {
        this.times = times;
        this.units = units;
        if (recalculateOrdinals) {
            this.setOrdinalsFromTimes();
        }
    }

    public TimeOrderCharacterData scale(double rate, int newUnits) {
        TimeOrderCharacterData scaled = TimeOrderCharacterData.clone(this);
        scaled.units = newUnits;
        int i = 0;
        while (i < this.times.length) {
            scaled.times[i] = this.times[i] * rate;
            ++i;
        }
        return scaled;
    }

    public void setOrdinals(int[] ordinals) {
        this.timeOrdinals = ordinals;
    }

    public int[] getOrdinals() {
        return this.timeOrdinals;
    }

    public double[] getCopyOfTimes() {
        double[] copyTimes = new double[this.times.length];
        System.arraycopy(this.times, 0, copyTimes, 0, this.times.length);
        return copyTimes;
    }

    public void removeTimes() {
        this.times = null;
    }

    public void setOrdinals(TimeOrderCharacterData tocd) {
        this.setOrdinals(tocd, null, false);
    }

    public void setTimesAndOrdinals(TimeOrderCharacterData tocd) {
        this.setOrdinals(tocd, null, true);
    }

    public void setOrdinals(TimeOrderCharacterData tocd, IdGroup standard, boolean doTimes) {
        if (this.timeOrdinals == null) {
            this.timeOrdinals = new int[this.taxa.getIdCount()];
        }
        if (doTimes && tocd.hasTimes()) {
            this.times = new double[this.taxa.getIdCount()];
        }
        if (standard == null) {
            standard = tocd;
        }
        int i = 0;
        while (i < this.taxa.getIdCount()) {
            String name = this.taxa.getIdentifier(i).getName();
            int index = standard.whichIdNumber(name);
            if (index == -1) {
                System.err.println("Identifiers don't match!");
                System.err.println("Trying to find: '" + name + "' in:");
                System.err.println(standard);
            }
            this.timeOrdinals[i] = tocd.getTimeOrdinal(index);
            if (doTimes && tocd.hasTimes()) {
                this.times[i] = tocd.getTime(index);
            }
            ++i;
        }
    }

    private void setOrdinalsFromTimes() {
        int[] indices = new int[this.times.length];
        this.timeOrdinals = new int[this.times.length];
        HeapSort.sort(this.times, indices);
        int ordinal = 0;
        int lastIndex = 0;
        this.timeOrdinals[indices[0]] = ordinal;
        int i = 1;
        while (i < indices.length) {
            if (!(Math.abs(this.times[indices[i]] - this.times[indices[lastIndex]]) <= 5.0E-7)) {
                lastIndex = i;
            }
            this.timeOrdinals[indices[i]] = ++ordinal;
            ++i;
        }
    }

    public int getNumChars() {
        if (this.hasTimes()) {
            return 2;
        }
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getTime(int taxon) {
        return this.times[taxon];
    }

    public double getHeight(int taxon, double rate) {
        return this.times[taxon] * rate;
    }

    public int getTimeOrdinal(int taxon) {
        return this.timeOrdinals[taxon];
    }

    public boolean hasTimes() {
        return this.times != null;
    }

    public double[] getUniqueTimeArray() {
        int count = this.getSampleCount();
        double[] utimes = new double[count];
        int i = 0;
        while (i < this.times.length) {
            utimes[this.getTimeOrdinal((int)i)] = this.times[i];
            ++i;
        }
        return utimes;
    }

    public double[][] getUniqueTimeMatrix() {
        double[] utimes = this.getUniqueTimeArray();
        int count = utimes.length;
        double[][] stimes = new double[count][count];
        int i = 0;
        while (i < count) {
            int j = 0;
            while (j < count) {
                stimes[i][j] = Math.abs(utimes[i] - utimes[j]);
                ++j;
            }
            ++i;
        }
        return stimes;
    }

    public int getSampleCount() {
        int max = 0;
        int i = 0;
        while (i < this.timeOrdinals.length) {
            if (this.timeOrdinals[i] > max) {
                max = this.timeOrdinals[i];
            }
            ++i;
        }
        return max + 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Identifier\t" + (this.hasTimes() ? "Times\t" : "") + "Sample\n");
        int i = 0;
        while (i < this.taxa.getIdCount()) {
            sb.append(this.taxa.getIdentifier(i) + "\t" + (this.hasTimes() ? this.getTime(i) + "\t" : "") + this.getTimeOrdinal(i) + "\n");
            ++i;
        }
        return new String(sb);
    }

    public void shuffleTimes() {
        MersenneTwisterFast mtf = new MersenneTwisterFast();
        int[] indices = mtf.shuffled(this.timeOrdinals.length);
        int[] newOrdinals = new int[this.timeOrdinals.length];
        double[] newTimes = null;
        if (this.hasTimes()) {
            newTimes = new double[this.times.length];
        }
        int i = 0;
        while (i < this.timeOrdinals.length) {
            newOrdinals[i] = this.timeOrdinals[indices[i]];
            if (this.hasTimes()) {
                newTimes[i] = this.times[indices[i]];
            }
            ++i;
        }
        this.timeOrdinals = newOrdinals;
        if (this.hasTimes()) {
            this.times = newTimes;
        }
    }

    public Identifier getIdentifier(int i) {
        return this.taxa.getIdentifier(i);
    }

    public void setIdentifier(int i, Identifier ident) {
        this.taxa.setIdentifier(i, ident);
    }

    public int getIdCount() {
        return this.taxa.getIdCount();
    }

    public int whichIdNumber(String name) {
        return this.taxa.whichIdNumber(name);
    }

    public IdGroup getIdGroup() {
        return this.taxa;
    }

    static {
        serialVersionUID = 7672390862755080486L;
    }
}

