/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import pal.datatype.DataType;
import pal.misc.PalObjectEvent;
import pal.misc.PalObjectListener;
import pal.misc.Utils;
import pal.substmodel.RateMatrix;
import pal.util.DefaultCache;
import pal.util.DoubleKey;
import pal.util.DoubleKeyCache;

public class CachedRateMatrix
implements RateMatrix,
PalObjectListener {
    private static final double TOLERANCE = 1.0E-8;
    private DoubleKeyCache cache;
    private Pij pij;
    private RateMatrix rateMatrix;
    private int dimension;
    boolean modelChanged_ = false;

    public CachedRateMatrix(RateMatrix rateMatrix, DoubleKeyCache cache) {
        this.rateMatrix = rateMatrix;
        this.dimension = rateMatrix.getDimension();
        this.cache = cache;
        this.rateMatrix.addPalObjectListener(this);
    }

    public CachedRateMatrix(RateMatrix rateMatrix, int maxCacheSize) {
        this(rateMatrix, new DefaultCache(maxCacheSize));
    }

    public CachedRateMatrix(CachedRateMatrix cachedRateMatrix) {
        this.rateMatrix = (RateMatrix)cachedRateMatrix.rateMatrix.clone();
        this.rateMatrix.addPalObjectListener(this);
        this.dimension = cachedRateMatrix.dimension;
        this.cache = cachedRateMatrix.cache;
    }

    public final void report(PrintWriter out) {
        this.rateMatrix.report(out);
    }

    public final int getTypeID() {
        return this.rateMatrix.getTypeID();
    }

    public final int getModelID() {
        return this.rateMatrix.getModelID();
    }

    public final int getDimension() {
        return this.dimension;
    }

    public final double[] getEquilibriumFrequencies() {
        return this.rateMatrix.getEquilibriumFrequencies();
    }

    public final double getEquilibriumFrequency(int i) {
        return this.rateMatrix.getEquilibriumFrequency(i);
    }

    public final double[][] getRelativeRates() {
        return this.rateMatrix.getRelativeRates();
    }

    public String toString() {
        return this.rateMatrix.toString();
    }

    public final int getNumParameters() {
        return this.rateMatrix.getNumParameters();
    }

    public final void setParameter(double param, int n) {
        this.rateMatrix.setParameter(param, n);
        this.modelChanged_ = true;
    }

    public final double getParameter(int n) {
        return this.rateMatrix.getParameter(n);
    }

    public final void setParameterSE(double paramSE, int n) {
        this.rateMatrix.setParameterSE(paramSE, n);
    }

    public final double getLowerLimit(int n) {
        return this.rateMatrix.getLowerLimit(n);
    }

    public final double getUpperLimit(int n) {
        return this.rateMatrix.getUpperLimit(n);
    }

    public final double getDefaultValue(int n) {
        return this.rateMatrix.getDefaultValue(n);
    }

    public final String getParameterName(int i) {
        return this.rateMatrix.getParameterName(i);
    }

    public final void setDistance(double k) {
        if (this.modelChanged_) {
            this.cache.clearCache();
        }
        this.pij = (Pij)this.cache.getNearest(k, 1.0E-8);
        if (this.pij == null) {
            this.rateMatrix.setDistance(k);
            double[][] probs = new double[this.dimension][this.dimension];
            this.rateMatrix.getTransitionProbabilities(probs);
            this.pij = new Pij(k, probs);
            this.cache.addDoubleKey(k, this.pij);
        }
        this.modelChanged_ = false;
    }

    public final double getTransitionProbability(int i, int j) {
        return this.pij.probs[i][j];
    }

    public final void getTransitionProbabilities(double[][] probs) {
        Utils.copy(this.pij.probs, probs);
    }

    public final Object clone() {
        return new CachedRateMatrix(this);
    }

    public final DataType getDataType() {
        return this.rateMatrix.getDataType();
    }

    public final String getUniqueName() {
        return this.rateMatrix.getUniqueName();
    }

    public void structureChanged(PalObjectEvent pe) {
        this.modelChanged_ = true;
    }

    public void parametersChanged(PalObjectEvent pe) {
        this.modelChanged_ = true;
    }

    public void addPalObjectListener(PalObjectListener pol) {
        this.rateMatrix.addPalObjectListener(pol);
    }

    public void removePalObjectListener(PalObjectListener pol) {
        this.rateMatrix.removePalObjectListener(pol);
    }

    static {
        TOLERANCE = 1.0E-8;
    }

    static final class Pij
    implements DoubleKey {
        public double[][] probs;
        public double distance;

        public Pij(double distance, double[][] probs) {
            this.probs = probs;
            this.distance = distance;
        }

        public double getKey() {
            return this.distance;
        }

        public int compareTo(Object o) {
            DoubleKey dk = (DoubleKey)o;
            double d2 = dk.getKey();
            if (this.distance < d2) {
                return -1;
            }
            if (this.distance == d2) {
                return 0;
            }
            return 1;
        }
    }

    static final class DK
    implements DoubleKey {
        double d;

        public DK(double d) {
            this.d = d;
        }

        public final double getKey() {
            return this.d;
        }

        public int compareTo(Object o) {
            DoubleKey dk = (DoubleKey)o;
            double d2 = dk.getKey();
            if (this.d < d2) {
                return -1;
            }
            if (this.d == d2) {
                return 0;
            }
            return 1;
        }
    }
}

