/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.substmodel.RateDistribution;

public class InvariableSites
extends RateDistribution
implements Serializable {
    private boolean showSE;
    private double frac;
    private double fracSE;

    public InvariableSites(double f) {
        super(2);
        this.frac = f;
        this.showSE = false;
        this.makeDistrib(this.frac);
    }

    public void report(PrintWriter out) {
        out.println("Model of rate heterogeneity: Invariable sites model");
        out.println("Number of rate categories: " + this.numRates);
        out.print("Fraction of invariable sites: ");
        this.format.displayDecimal(out, this.frac, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.fracSE, 2);
            out.println(")");
        } else {
            out.println();
        }
        out.println();
        this.printRates(out);
    }

    public int getNumParameters() {
        return 1;
    }

    public void setParameter(double param, int n) {
        this.frac = param;
        this.makeDistrib(this.frac);
    }

    public double getParameter(int n) {
        return this.frac;
    }

    public void setParameterSE(double paramSE, int n) {
        this.fracSE = paramSE;
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 0.0;
    }

    public double getUpperLimit(int n) {
        return 1.0;
    }

    public double getDefaultValue(int n) {
        return 0.0;
    }

    private void makeDistrib(double f) {
        this.rate[0] = 0.0;
        this.rate[1] = 1.0 / (1.0 - f);
        this.probability[0] = f;
        this.probability[1] = 1.0 - f;
    }
}

