/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.distance.DistanceMatrix;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.NodeUtils;
import pal.tree.SimpleTree;

public class NeighborJoiningTree
extends SimpleTree {
    private int numClusters;
    private Node newCluster;
    private int besti;
    private int abi;
    private int bestj;
    private int abj;
    private int[] alias;
    private double[][] distance;
    private double[] r;
    private double scale;

    public NeighborJoiningTree(DistanceMatrix m) {
        if (m.numSeqs < 3) {
            new IllegalArgumentException("LESS THAN 3 TAXA IN DISTANCE MATRIX");
        }
        if (!m.isSymmetric()) {
            new IllegalArgumentException("UNSYMMETRIC DISTANCE MATRIX");
        }
        this.init(m);
        while (true) {
            this.findNextPair();
            this.newBranchLengths();
            if (this.numClusters == 3) break;
            this.newCluster();
        }
        this.finish();
    }

    private double getDist(int a, int b) {
        return this.distance[this.alias[a]][this.alias[b]];
    }

    private void init(DistanceMatrix m) {
        this.numClusters = m.numSeqs;
        this.distance = new double[this.numClusters][this.numClusters];
        int i = 0;
        while (i < this.numClusters) {
            int j = 0;
            while (j < this.numClusters) {
                this.distance[i][j] = m.distance[i][j];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numClusters) {
            Node tmp = NodeFactory.createNode();
            tmp.setIdentifier(m.getIdentifier(i2));
            this.getRoot().addChild(tmp);
            ++i2;
        }
        this.alias = new int[this.numClusters];
        int i3 = 0;
        while (i3 < this.numClusters) {
            this.alias[i3] = i3;
            ++i3;
        }
        this.r = new double[this.numClusters];
    }

    private void finish() {
        if (this.besti != 0 && this.bestj != 0) {
            this.getRoot().getChild(0).setBranchLength(this.updatedDistance(this.besti, this.bestj, 0));
        } else if (this.besti != 1 && this.bestj != 1) {
            this.getRoot().getChild(1).setBranchLength(this.updatedDistance(this.besti, this.bestj, 1));
        } else {
            this.getRoot().getChild(2).setBranchLength(this.updatedDistance(this.besti, this.bestj, 2));
        }
        this.distance = null;
        NodeUtils.lengths2Heights(this.getRoot());
    }

    private void findNextPair() {
        int i = 0;
        while (i < this.numClusters) {
            this.r[i] = 0.0;
            int j = 0;
            while (j < this.numClusters) {
                int n = i;
                this.r[n] = this.r[n] + this.getDist(i, j);
                ++j;
            }
            ++i;
        }
        this.besti = 0;
        this.bestj = 1;
        double smax = -1.0;
        this.scale = 1.0 / (double)(this.numClusters - 2);
        int i2 = 0;
        while (i2 < this.numClusters - 1) {
            int j = i2 + 1;
            while (j < this.numClusters) {
                double sij = (this.r[i2] + this.r[j]) * this.scale - this.getDist(i2, j);
                if (sij > smax) {
                    smax = sij;
                    this.besti = i2;
                    this.bestj = j;
                }
                ++j;
            }
            ++i2;
        }
        this.abi = this.alias[this.besti];
        this.abj = this.alias[this.bestj];
    }

    private void newBranchLengths() {
        double dij = this.getDist(this.besti, this.bestj);
        double li = (dij + (this.r[this.besti] - this.r[this.bestj]) * this.scale) * 0.5;
        double lj = dij - li;
        this.getRoot().getChild(this.besti).setBranchLength(li);
        this.getRoot().getChild(this.bestj).setBranchLength(lj);
    }

    private void newCluster() {
        int k = 0;
        while (k < this.numClusters) {
            if (k != this.besti && k != this.bestj) {
                int ak = this.alias[k];
                double d = this.updatedDistance(this.besti, this.bestj, k);
                this.distance[this.abi][ak] = d;
                this.distance[ak][this.abi] = d;
            }
            ++k;
        }
        this.distance[this.abi][this.abi] = 0.0;
        NodeUtils.joinChilds(this.getRoot(), this.besti, this.bestj);
        int i = this.bestj;
        while (i < this.numClusters - 1) {
            this.alias[i] = this.alias[i + 1];
            ++i;
        }
        --this.numClusters;
    }

    private double updatedDistance(int i, int j, int k) {
        return (this.getDist(k, i) + this.getDist(k, j) - this.getDist(i, j)) * 0.5;
    }
}

