/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.alignment.AbstractAlignment;
import pal.datatype.DataTypeUtils;
import pal.math.MersenneTwisterFast;
import pal.misc.SimpleIdGroup;
import pal.substmodel.SubstitutionModel;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.Tree;

public class SimulatedAlignment
extends AbstractAlignment {
    private Tree tree;
    private SubstitutionModel model;
    private double[] cumFreqs;
    private int[] rateAtSite;
    private double[] cumRateProbs;
    private int numStates;
    private byte[][] stateData;
    private MersenneTwisterFast rng = new MersenneTwisterFast();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.tree);
        out.writeObject(this.model);
        out.writeObject(this.cumFreqs);
        out.writeObject(this.rateAtSite);
        out.writeObject(this.cumRateProbs);
        out.writeObject(this.stateData);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.tree = (Tree)in.readObject();
        this.model = (SubstitutionModel)in.readObject();
        this.cumFreqs = (double[])in.readObject();
        this.rateAtSite = (int[])in.readObject();
        this.cumRateProbs = (double[])in.readObject();
        this.stateData = (byte[][])in.readObject();
        this.numStates = this.dataType.getNumStates();
        this.rng = new MersenneTwisterFast();
    }

    public SimulatedAlignment(int sites, Tree t, SubstitutionModel m) {
        this.dataType = m.getRateMatrix().getDataType();
        this.numStates = this.dataType.getNumStates();
        this.model = m;
        this.tree = t;
        this.tree.createNodeList();
        this.numSeqs = this.tree.getExternalNodeCount();
        this.numSites = sites;
        this.idGroup = new SimpleIdGroup(this.numSeqs);
        int i = 0;
        while (i < this.numSeqs) {
            this.idGroup.setIdentifier(i, this.tree.getExternalNode(i).getIdentifier());
            ++i;
        }
        this.stateData = new byte[this.numSeqs][this.numSites];
        int i2 = 0;
        while (i2 < this.tree.getExternalNodeCount()) {
            this.tree.getExternalNode(i2).setSequence(this.stateData[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.tree.getInternalNodeCount() - 1) {
            this.tree.getInternalNode(i3).setSequence(new byte[this.numSites]);
            ++i3;
        }
        this.rateAtSite = new int[this.numSites];
        this.cumFreqs = new double[this.numStates];
        this.cumRateProbs = new double[m.getRateDistribution().numRates];
    }

    public char getData(int seq, int site) {
        return this.dataType.getChar(this.stateData[seq][site]);
    }

    public void simulate() {
        this.simulate(this.makeRandomRootSequence());
    }

    public void simulate(String givenRootSequence) {
        this.simulate(DataTypeUtils.getByteStates(givenRootSequence, this.model.getRateMatrix().getDataType()));
    }

    public void simulate(byte[] rootSeq) {
        int i = 0;
        while (i < this.numSites) {
            if (rootSeq[i] >= this.numStates || rootSeq[i] < 0) {
                throw new IllegalArgumentException("Root sequence contains illegal state (?,-, etc.)");
            }
            ++i;
        }
        this.tree.getInternalNode(this.tree.getInternalNodeCount() - 1).setSequence(rootSeq);
        this.assignRates();
        Node node = NodeUtils.preorderSuccessor(this.tree.getRoot());
        do {
            this.determineMutatedSequence(node);
        } while ((node = NodeUtils.preorderSuccessor(node)) != this.tree.getRoot());
    }

    private void determineMutatedSequence(Node node) {
        if (node.isRoot()) {
            throw new IllegalArgumentException("Root node not allowed");
        }
        this.model.setDistance(node.getBranchLength());
        byte[] oldS = node.getParent().getSequence();
        byte[] newS = node.getSequence();
        int i = 0;
        while (i < this.numSites) {
            this.cumFreqs[0] = this.model.transProb(this.rateAtSite[i], oldS[i], 0);
            int j = 1;
            while (j < this.numStates) {
                this.cumFreqs[j] = this.cumFreqs[j - 1] + this.model.transProb(this.rateAtSite[i], oldS[i], j);
                ++j;
            }
            newS[i] = (byte)this.randomChoice(this.cumFreqs);
            ++i;
        }
    }

    private byte[] makeRandomRootSequence() {
        double[] frequencies = this.model.getRateMatrix().getEquilibriumFrequencies();
        this.cumFreqs[0] = frequencies[0];
        int i = 1;
        while (i < this.numStates) {
            this.cumFreqs[i] = this.cumFreqs[i - 1] + frequencies[i];
            ++i;
        }
        byte[] rootSequence = new byte[this.numSites];
        int i2 = 0;
        while (i2 < this.numSites) {
            rootSequence[i2] = (byte)this.randomChoice(this.cumFreqs);
            ++i2;
        }
        return rootSequence;
    }

    private void assignRates() {
        this.cumRateProbs[0] = this.model.getRateDistribution().probability[0];
        int i = 1;
        while (i < this.model.getRateDistribution().numRates) {
            this.cumRateProbs[i] = this.cumRateProbs[i - 1] + this.model.getRateDistribution().probability[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numSites) {
            this.rateAtSite[i2] = this.randomChoice(this.cumRateProbs);
            ++i2;
        }
    }

    private int randomChoice(double[] cf) {
        int s;
        double rnd = this.rng.nextDouble();
        if (rnd <= cf[0]) {
            s = 0;
        } else {
            s = 1;
            while (s < cf.length) {
                if (rnd <= cf[s] && rnd > cf[s - 1]) break;
                ++s;
            }
        }
        return s;
    }
}

