/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.misc.IdGroup;
import pal.tree.Node;
import pal.tree.SplitSystem;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class SplitUtils {
    public static SplitSystem getSplits(IdGroup idGroup, Tree tree) {
        tree.createNodeList();
        int size = tree.getInternalNodeCount() - 1;
        SplitSystem splitSystem = new SplitSystem(idGroup, size);
        boolean[][] splits = splitSystem.getSplitVector();
        int i = 0;
        while (i < size) {
            SplitUtils.getSplit(idGroup, tree.getInternalNode(i), splits[i]);
            ++i;
        }
        return splitSystem;
    }

    public static SplitSystem getSplits(Tree tree) {
        IdGroup idGroup = TreeUtils.getLeafIdGroup(tree);
        return SplitUtils.getSplits(idGroup, tree);
    }

    public static void getSplit(IdGroup idGroup, Node internalNode, boolean[] split) {
        if (internalNode.isLeaf() || internalNode.isRoot()) {
            throw new IllegalArgumentException("Only internal nodes (and no root) nodes allowed");
        }
        int i = 0;
        while (i < split.length) {
            split[i] = false;
            ++i;
        }
        int i2 = 0;
        while (i2 < internalNode.getChildCount()) {
            SplitUtils.markNode(idGroup, internalNode, split);
            ++i2;
        }
        if (!split[0]) {
            int i3 = 0;
            while (i3 < split.length) {
                split[i3] = !split[i3];
                ++i3;
            }
        }
    }

    public static boolean isSame(boolean[] s1, boolean[] s2) {
        boolean reverse = s1[0] != s2[0];
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Splits must be of the same length!");
        }
        int i = 0;
        while (i < s1.length) {
            if (reverse ? s1[i] == s2[i] : s1[i] != s2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void markNode(IdGroup idGroup, Node node, boolean[] split) {
        if (node.isLeaf()) {
            String name = node.getIdentifier().getName();
            int index = idGroup.whichIdNumber(name);
            if (index < 0) {
                throw new IllegalArgumentException("INCOMPATIBLE IDENTIFIER (" + name + ")");
            }
            split[index] = true;
        } else {
            int i = 0;
            while (i < node.getChildCount()) {
                SplitUtils.markNode(idGroup, node.getChild(i), split);
                ++i;
            }
        }
    }
}

