/*
 * Decompiled with CFR 0.152.
 */
package pal.util;

import java.util.Vector;
import pal.math.MersenneTwisterFast;
import pal.util.Comparable;
import pal.util.ComparableDouble;
import pal.util.Comparator;

public class HeapSort {
    public static void sort(Vector array, int[] indices) {
        int i = 0;
        while (i < indices.length) {
            indices[i] = i;
            ++i;
        }
        int n = array.size();
        int j = n / 2;
        while (j > 0) {
            HeapSort.adjust(array, indices, j, n);
            --j;
        }
        j = n - 1;
        while (j > 0) {
            int temp = indices[0];
            indices[0] = indices[j];
            indices[j] = temp;
            HeapSort.adjust(array, indices, 1, j);
            --j;
        }
    }

    public static void sort(Vector array) {
        int n = array.size();
        int j = n / 2;
        while (j > 0) {
            HeapSort.adjust(array, j, n);
            --j;
        }
        j = n - 1;
        while (j > 0) {
            Object temp = array.elementAt(0);
            array.setElementAt(array.elementAt(j), 0);
            array.setElementAt(temp, j);
            HeapSort.adjust(array, 1, j);
            --j;
        }
    }

    public static void sort(Comparable[] array) {
        int n = array.length;
        int j = n / 2;
        while (j > 0) {
            HeapSort.adjust(array, j, n);
            --j;
        }
        j = n - 1;
        while (j > 0) {
            Comparable temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjust(array, 1, j);
            --j;
        }
    }

    public static void sort(Object[] array, Comparator c) {
        int n = array.length;
        int j = n / 2;
        while (j > 0) {
            HeapSort.adjust(array, c, j, n);
            --j;
        }
        j = n - 1;
        while (j > 0) {
            Object temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjust(array, c, 1, j);
            --j;
        }
    }

    public static void sort(double[] array) {
        int n = array.length;
        int j = n / 2;
        while (j > 0) {
            HeapSort.adjust(array, j, n);
            --j;
        }
        j = n - 1;
        while (j > 0) {
            double temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjust(array, 1, j);
            --j;
        }
    }

    public static void sortAbs(double[] array) {
        int n = array.length;
        int j = n / 2;
        while (j > 0) {
            HeapSort.adjustAbs(array, j, n);
            --j;
        }
        j = n - 1;
        while (j > 0) {
            double temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjustAbs(array, 1, j);
            --j;
        }
    }

    public static void sort(double[] array, int[] indices) {
        int i = 0;
        while (i < indices.length) {
            indices[i] = i;
            ++i;
        }
        int n = array.length;
        int j = n / 2;
        while (j > 0) {
            HeapSort.adjust(array, indices, j, n);
            --j;
        }
        j = n - 1;
        while (j > 0) {
            int temp = indices[0];
            indices[0] = indices[j];
            indices[j] = temp;
            HeapSort.adjust(array, indices, 1, j);
            --j;
        }
    }

    public static void main(String[] args) {
        MersenneTwisterFast m = new MersenneTwisterFast();
        int testSize = 100;
        Comparable[] test = new ComparableDouble[testSize];
        int i = 0;
        while (i < test.length) {
            test[i] = new ComparableDouble(m.nextInt(testSize * 10));
            ++i;
        }
        HeapSort.sort(test);
        int i2 = 0;
        while (i2 < test.length) {
            System.out.print(test[i2] + " ");
            ++i2;
        }
        System.out.println();
        Vector<ComparableDouble> testv = new Vector<ComparableDouble>();
        int[] indices = new int[testSize];
        int i3 = 0;
        while (i3 < testSize) {
            testv.addElement(new ComparableDouble(m.nextInt(testSize * 10)));
            ++i3;
        }
        HeapSort.sort(testv, indices);
        int i4 = 0;
        while (i4 < test.length) {
            System.out.print(testv.elementAt(indices[i4]) + " ");
            ++i4;
        }
        System.out.println();
        double[] testd = new double[testSize];
        int i5 = 0;
        while (i5 < testSize) {
            testd[i5] = m.nextInt(testSize * 10);
            ++i5;
        }
        HeapSort.sort(testd, indices);
        int i6 = 0;
        while (i6 < test.length) {
            System.out.print(testd[indices[i6]] + " ");
            ++i6;
        }
        System.out.println();
    }

    private static void adjust(Vector array, int[] indices, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && ((Comparable)array.elementAt(indices[k - 1])).compareTo(array.elementAt(indices[k])) < 0) {
                ++k;
            }
            if (((Comparable)array.elementAt(indices[j - 1])).compareTo(array.elementAt(indices[k - 1])) < 0) {
                int temp = indices[j - 1];
                indices[j - 1] = indices[k - 1];
                indices[k - 1] = temp;
            }
            j = k;
            k *= 2;
        }
    }

    private static void adjust(Vector array, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && ((Comparable)array.elementAt(k - 1)).compareTo(array.elementAt(k)) < 0) {
                ++k;
            }
            if (((Comparable)array.elementAt(j - 1)).compareTo(array.elementAt(k - 1)) < 0) {
                Object temp = array.elementAt(j - 1);
                array.setElementAt(array.elementAt(k - 1), j - 1);
                array.setElementAt(temp, k - 1);
            }
            j = k;
            k *= 2;
        }
    }

    private static void adjust(Comparable[] array, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && array[k - 1].compareTo(array[k]) < 0) {
                ++k;
            }
            if (array[j - 1].compareTo(array[k - 1]) < 0) {
                Comparable temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
            k *= 2;
        }
    }

    private static void adjust(Object[] array, Comparator c, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && c.compare(array[k - 1], array[k]) < 0) {
                ++k;
            }
            if (c.compare(array[j - 1], array[k - 1]) < 0) {
                Object temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
            k *= 2;
        }
    }

    private static void adjust(double[] array, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && array[k - 1] < array[k]) {
                ++k;
            }
            if (array[j - 1] < array[k - 1]) {
                double temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
            k *= 2;
        }
    }

    private static void adjustAbs(double[] array, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && Math.abs(array[k - 1]) < Math.abs(array[k])) {
                ++k;
            }
            if (Math.abs(array[j - 1]) < Math.abs(array[k - 1])) {
                double temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
            k *= 2;
        }
    }

    private static void adjust(double[] array, int[] indices, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && array[indices[k - 1]] < array[indices[k]]) {
                ++k;
            }
            if (array[indices[j - 1]] < array[indices[k - 1]]) {
                int temp = indices[j - 1];
                indices[j - 1] = indices[k - 1];
                indices[k - 1] = temp;
            }
            j = k;
            k *= 2;
        }
    }
}

