/*
 * Decompiled with CFR 0.152.
 */
package pal.xml;

import java.util.Enumeration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pal.alignment.Alignment;
import pal.coalescent.ConstExpGrowth;
import pal.coalescent.ConstantPopulation;
import pal.coalescent.DemographicModel;
import pal.coalescent.ExponentialGrowth;
import pal.mep.ConstantMutationRate;
import pal.mep.MutationRateModel;
import pal.mep.SteppedMutationRate;
import pal.misc.Attribute;
import pal.misc.Identifier;
import pal.misc.TimeOrderCharacterData;
import pal.substmodel.RateMatrix;
import pal.tree.AttributeNode;
import pal.tree.Node;
import pal.tree.Tree;
import pal.util.XMLConstants;

public class ElementFactory
implements XMLConstants {
    public static Element createAlignmentElement(Alignment a, Document document) {
        Element alignmentNode = document.createElement("alignment");
        alignmentNode.setAttribute("datatype", a.getDataType().getDescription());
        alignmentNode.setAttribute("datatypeid", a.getDataType().getTypeID() + "");
        int i = 0;
        while (i < a.getSequenceCount()) {
            alignmentNode.appendChild(ElementFactory.createSequenceElement(a.getIdentifier(i), a.getAlignedSequenceString(i), document));
            ++i;
        }
        return alignmentNode;
    }

    public static Element createAttributeElement(Attribute a, Document document) {
        Element attNode = document.createElement("att");
        Object value = a.getValue();
        String type = "string";
        if (value instanceof Double) {
            type = "double";
        }
        if (value instanceof Float) {
            type = "float";
        }
        if (value instanceof Boolean) {
            type = "boolean";
        }
        if (value instanceof Integer) {
            type = "integer";
        }
        attNode.setAttribute("name", a.getName());
        attNode.setAttribute("value", value.toString());
        attNode.setAttribute("type", type);
        return attNode;
    }

    public static Element createDemographicModelElement(DemographicModel demo, Document document) {
        Element demoNode = document.createElement("demographicmodel");
        if (demo instanceof ConstExpGrowth) {
            demoNode.setAttribute("type", "constexp");
            ConstExpGrowth ceg = (ConstExpGrowth)demo;
            if (ceg.getParameterization() == 0) {
                demoNode.appendChild(ElementFactory.createParameterElement("alpha", ceg.getAncestral(), document));
            } else {
                demoNode.appendChild(ElementFactory.createParameterElement("ancestral population size", ceg.getAncestral(), document));
            }
        } else if (demo instanceof ExponentialGrowth) {
            demoNode.setAttribute("type", "exponential");
            demoNode.appendChild(ElementFactory.createParameterElement("growth rate", ((ExponentialGrowth)demo).getGrowthRate(), document));
        } else if (demo instanceof ConstantPopulation) {
            demoNode.setAttribute("type", "constant");
            demoNode.appendChild(ElementFactory.createParameterElement("current population size", ((ConstantPopulation)demo).getN0(), document));
        }
        demoNode.setAttribute("units", ElementFactory.getUnitString(demo.getUnits()));
        return demoNode;
    }

    public static Element createEdgeNodeElement(Node node, Document document) {
        Element edgeNode = document.createElement("edge");
        edgeNode.setAttribute("length", node.getBranchLength() + "");
        int i = 0;
        while (i < node.getChildCount()) {
            edgeNode.appendChild(ElementFactory.createNodeElement(node.getChild(i), document, true));
            ++i;
        }
        return edgeNode;
    }

    public static Element createFrequenciesElement(double[] frequencies, Document d) {
        Element freqNode = d.createElement("frequencies");
        String freqs = frequencies[0] + " ";
        int i = 1;
        while (i < frequencies.length) {
            freqs = freqs + " " + frequencies[i];
            ++i;
        }
        freqNode.appendChild(d.createTextNode(freqs));
        return freqNode;
    }

    public static Element createMutationRateModelElement(MutationRateModel muModel, Document document) {
        Element muNode = document.createElement("mutationratemodel");
        if (muModel instanceof SteppedMutationRate) {
            muNode.setAttribute("type", "stepped");
            SteppedMutationRate smr = (SteppedMutationRate)muModel;
            muNode.appendChild(ElementFactory.createParameterElement("current mutation rate", smr.mus[0], document));
            muNode.appendChild(ElementFactory.createParameterElement("ancestral mutation rate", smr.mus[1], document));
            muNode.appendChild(ElementFactory.createParameterElement("step time", smr.muChanges[0], document));
        } else if (muModel instanceof ConstantMutationRate) {
            muNode.setAttribute("type", "constant");
            muNode.appendChild(ElementFactory.createParameterElement("current mutation rate", muModel.getMutationRate(0.0), document));
        }
        return muNode;
    }

    public static Element createNodeElement(Node node, Document document) {
        return ElementFactory.createNodeElement(node, document, false);
    }

    public static Element createNodeElement(Node node, Document document, boolean includeEdges) {
        Element nodeNode = document.createElement("node");
        nodeNode.setAttribute("height", node.getNodeHeight() + "");
        nodeNode.setAttribute("name", node.getIdentifier().getName());
        if (node instanceof AttributeNode) {
            AttributeNode attNode = (AttributeNode)node;
            Enumeration e = attNode.getAttributeNames();
            while (e != null && e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object value = attNode.getAttribute(name);
                nodeNode.appendChild(ElementFactory.createAttributeElement(new Attribute(name, value), document));
            }
        }
        int i = 0;
        while (i < node.getChildCount()) {
            if (includeEdges) {
                nodeNode.appendChild(ElementFactory.createEdgeNodeElement(node.getChild(i), document));
            } else {
                nodeNode.appendChild(ElementFactory.createNodeElement(node.getChild(i), document));
            }
            ++i;
        }
        return nodeNode;
    }

    public static Element createParameterElement(String name, double value, Document document) {
        Element parameterNode = document.createElement("parameter");
        parameterNode.setAttribute("name", name);
        parameterNode.setAttribute("value", value + "");
        return parameterNode;
    }

    public static Element createRateMatrixElement(RateMatrix matrix, Document d) {
        Element matrixNode = d.createElement("ratematrix");
        matrixNode.setAttribute("model", matrix.getUniqueName());
        matrixNode.setAttribute("datatype", matrix.getDataType().getDescription());
        matrixNode.setAttribute("datatypeid", matrix.getDataType().getTypeID() + "");
        matrixNode.appendChild(ElementFactory.createFrequenciesElement(matrix.getEquilibriumFrequencies(), d));
        int i = 0;
        while (i < matrix.getNumParameters()) {
            matrixNode.appendChild(ElementFactory.createParameterElement(matrix.getParameterName(i), matrix.getParameter(i), d));
            ++i;
        }
        return matrixNode;
    }

    public static Element createSequenceElement(Identifier id, String sequence, Document document) {
        Element sequenceNode = document.createElement("sequence");
        sequenceNode.setAttribute("name", id.getName());
        sequenceNode.appendChild(document.createTextNode(sequence));
        return sequenceNode;
    }

    public static Element createTimeDataElement(TimeOrderCharacterData tocd, Document document) {
        Element timeDataNode = document.createElement("timedata");
        timeDataNode.setAttribute("units", ElementFactory.getUnitString(tocd.getUnits()));
        timeDataNode.setAttribute("origin", "0");
        timeDataNode.setAttribute("direction", "backwards");
        int i = 0;
        while (i < tocd.getIdCount()) {
            timeDataNode.appendChild(ElementFactory.createTimeElement(tocd.getIdentifier(i), tocd.getTime(i), document));
            ++i;
        }
        return timeDataNode;
    }

    public static Element createTreeElement(Tree tree, Document document, boolean includeEdges) {
        Element treeNode = document.createElement("tree");
        treeNode.setAttribute("units", ElementFactory.getUnitString(tree.getUnits()));
        treeNode.appendChild(ElementFactory.createNodeElement(tree.getRoot(), document, false));
        return treeNode;
    }

    private static Element createTimeElement(Identifier id, double time, Document document) {
        Element timeNode = document.createElement("time");
        timeNode.setAttribute("value", time + "");
        timeNode.appendChild(document.createTextNode(id.getName()));
        return timeNode;
    }

    private static String getUnitString(int units) {
        switch (units) {
            case 1: {
                return "generations";
            }
            case 2: {
                return "days";
            }
            case 3: {
                return "months";
            }
            case 4: {
                return "years";
            }
            case 0: {
                return "mutations";
            }
        }
        return "unknown";
    }
}

