/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TestCyclicity
extends TestCase {
    private JDepend jdepend;

    public TestCyclicity(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.jdepend = new JDepend();
        File file = new File("./build/tetrad/classes");
        try {
            this.jdepend.addDirectory(file.getAbsolutePath());
        }
        catch (IOException e) {
            TestCyclicity.fail(e.getMessage());
        }
    }

    @Override
    public void tearDown() {
        this.jdepend = null;
    }

    public void testBlank() {
    }

    public void rtestAllPackagesCycle() {
        Collection packages = this.jdepend.analyze();
        for (Object aPackage : packages) {
            JavaPackage p = (JavaPackage)aPackage;
            if (!p.containsCycle()) continue;
            System.out.println("\n***Package: " + p.getName() + ".");
            System.out.println();
            System.out.println("This package participates in a package cycle. In the following \nlist, for each i, some class in package i depends on some \nclass in package i + 1. Please find the cycle and remove it.");
            LinkedList l = new LinkedList();
            p.collectCycle(l);
            System.out.println();
            for (int j = 0; j < l.size(); ++j) {
                JavaPackage pack = (JavaPackage)l.get(j);
                System.out.println(j + 1 + ".\t" + pack.getName());
            }
            System.out.println();
        }
        if (this.jdepend.containsCycles()) {
            TestCyclicity.fail("Package cycle(s) found!");
        }
    }

    public static void main(String[] args) {
        TestRunner.run(TestCyclicity.class);
    }
}

