/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.ManipulatingBayesUpdater;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public final class ApproximateUpdater
implements ManipulatingBayesUpdater {
    static final long serialVersionUID = 23L;
    private BayesIm bayesIm;
    private Evidence evidence;
    private int[][] counts;
    private BayesIm manipulatedBayesIm;

    public ApproximateUpdater(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        this.bayesIm = bayesIm;
        this.setEvidence(Evidence.tautology(bayesIm));
    }

    public ApproximateUpdater(BayesIm bayesIm, Evidence evidence) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        this.bayesIm = bayesIm;
        this.setEvidence(evidence);
    }

    public static ApproximateUpdater serializableInstance() {
        return new ApproximateUpdater(MlBayesIm.serializableInstance());
    }

    @Override
    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    @Override
    public BayesIm getManipulatedBayesIm() {
        return this.manipulatedBayesIm;
    }

    @Override
    public Graph getManipulatedGraph() {
        return this.manipulatedBayesIm.getDag();
    }

    @Override
    public BayesIm getUpdatedBayesIm() {
        return null;
    }

    @Override
    public Evidence getEvidence() {
        return new Evidence(this.evidence);
    }

    @Override
    public final void setEvidence(Evidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        if (!evidence.isCompatibleWith(this.bayesIm)) {
            throw new IllegalArgumentException("The variables for the given evidence must be compatible with the Bayes IM being updated.");
        }
        this.evidence = new Evidence(evidence);
        Dag graph = this.bayesIm.getBayesPm().getDag();
        Dag manipulatedGraph = this.createManipulatedGraph(graph);
        BayesPm manipulatedBayesPm = this.createUpdatedBayesPm(manipulatedGraph);
        this.manipulatedBayesIm = this.createdUpdatedBayesIm(manipulatedBayesPm);
        this.counts = null;
    }

    @Override
    public double getMarginal(int variable, int value) {
        this.doUpdate();
        int sum = 0;
        for (int i = 0; i < this.manipulatedBayesIm.getNumColumns(variable); ++i) {
            sum += this.counts[variable][i];
        }
        return (double)this.counts[variable][value] / (double)sum;
    }

    @Override
    public boolean isJointMarginalSupported() {
        return false;
    }

    @Override
    public double getJointMarginal(int[] variables, int[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] calculatePriorMarginals(int nodeIndex) {
        Evidence evidence = this.getEvidence();
        this.setEvidence(Evidence.tautology(evidence.getVariableSource()));
        double[] marginals = new double[evidence.getNumCategories(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        this.setEvidence(evidence);
        return marginals;
    }

    @Override
    public double[] calculateUpdatedMarginals(int nodeIndex) {
        double[] marginals = new double[this.evidence.getNumCategories(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        return marginals;
    }

    public String toString() {
        return "Approximate updater, evidence = " + this.evidence;
    }

    private void doUpdate() {
        if (this.counts != null) {
            return;
        }
        this.counts = new int[this.manipulatedBayesIm.getNumNodes()][];
        for (int i = 0; i < this.manipulatedBayesIm.getNumNodes(); ++i) {
            this.counts[i] = new int[this.manipulatedBayesIm.getNumColumns(i)];
        }
        Graph graph = this.getManipulatedGraph();
        Dag dag = (Dag)graph;
        List<Node> tierOrdering = dag.getTierOrdering();
        int[] tiers = new int[tierOrdering.size()];
        for (int i = 0; i < tierOrdering.size(); ++i) {
            tiers[i] = this.getManipulatedBayesIm().getNodeIndex(tierOrdering.get(i));
        }
        int numCounted = 0;
        while (numCounted < 1000) {
            int[] point = ApproximateUpdater.getSinglePoint(this.getManipulatedBayesIm(), tiers);
            if (!this.evidence.getProposition().isPermissibleCombination(point)) continue;
            ++numCounted;
            for (int j = 0; j < this.getManipulatedBayesIm().getNumNodes(); ++j) {
                int[] nArray = this.counts[j];
                int n = point[j];
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private BayesIm createdUpdatedBayesIm(BayesPm updatedBayesPm) {
        return new MlBayesIm(updatedBayesPm, this.bayesIm, 1);
    }

    private BayesPm createUpdatedBayesPm(Dag updatedGraph) {
        return new BayesPm(updatedGraph, this.bayesIm.getBayesPm());
    }

    private Dag createManipulatedGraph(Graph graph) {
        Dag updatedGraph = new Dag(graph);
        for (int i = 0; i < this.evidence.getNumNodes(); ++i) {
            if (!this.evidence.isManipulated(i)) continue;
            Node node = this.evidence.getNode(i);
            List<Node> parents = updatedGraph.getParents(node);
            for (Node parent1 : parents) {
                updatedGraph.removeEdge(node, parent1);
            }
        }
        return updatedGraph;
    }

    private static int[] getSinglePoint(BayesIm bayesIm, int[] tiers) {
        int[] point = new int[bayesIm.getNumNodes()];
        int[] combination = new int[bayesIm.getNumNodes()];
        RandomUtil randomUtil = RandomUtil.getInstance();
        block0: for (int nodeIndex : tiers) {
            double cutoff = randomUtil.nextDouble();
            for (int k = 0; k < bayesIm.getNumParents(nodeIndex); ++k) {
                combination[k] = point[bayesIm.getParent(nodeIndex, k)];
            }
            int rowIndex = bayesIm.getRowIndex(nodeIndex, combination);
            double sum = 0.0;
            for (int k = 0; k < bayesIm.getNumColumns(nodeIndex); ++k) {
                double probability = bayesIm.getProbability(nodeIndex, rowIndex, k);
                if (Double.isNaN(probability)) {
                    throw new IllegalStateException("Some probability values in the BayesIm are not filled in; cannot simulate data to do approximate updating.");
                }
                if (!((sum += probability) >= cutoff)) continue;
                point[nodeIndex] = k;
                continue block0;
            }
        }
        return point;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
        if (this.evidence == null) {
            throw new NullPointerException();
        }
    }
}

