/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

final class BayesImFactory {
    BayesImFactory() {
    }

    public static BayesIm createBayesNet(String[] vars, List<String>[] varVals, String[] edges) {
        return BayesImFactory.createBayesNet(vars, varVals, edges, (String[][])null);
    }

    public static BayesIm createBayesNet(String[] vars, String[][] varVals, String[] edges) {
        ArrayList[] valVect = new ArrayList[varVals.length];
        for (int i = 0; i < valVect.length; ++i) {
            valVect[i] = new ArrayList();
            for (int j = 0; j < varVals[i].length; ++j) {
                valVect[i].add(varVals[i][j]);
            }
        }
        return BayesImFactory.createBayesNet(vars, valVect, edges, (String[][])null);
    }

    public static BayesIm createBayesNet(String[] vars, String[][] varVals, String[] edges, String[][] probs) {
        ArrayList[] valVect = new ArrayList[varVals.length];
        for (int i = 0; i < valVect.length; ++i) {
            valVect[i] = new ArrayList();
            for (int j = 0; j < varVals[i].length; ++j) {
                valVect[i].add(varVals[i][j]);
            }
        }
        return BayesImFactory.createBayesNet(vars, valVect, edges, probs);
    }

    private static BayesIm createBayesNet(String[] vars, List<String>[] varVals, String[] edges, String[][] probs) {
        Dag dag = new Dag();
        for (String var : vars) {
            GraphNode v = new GraphNode(var);
            dag.addNode(v);
        }
        for (String edge : edges) {
            StringTokenizer st = new StringTokenizer(edge, "->");
            Node node1 = dag.getNode(st.nextToken());
            Node node2 = dag.getNode(st.nextToken());
            dag.addDirectedEdge(node1, node2);
        }
        BayesPm bayesPm = new BayesPm(dag);
        for (int i = 0; i < varVals.length; ++i) {
            try {
                Node node = dag.getNode(vars[i]);
                LinkedList<String> categories = new LinkedList<String>();
                for (int j = 0; j < varVals[i].size(); ++j) {
                    categories.add(varVals[i].get(j));
                }
                bayesPm.setCategories(node, categories);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Problem setting node values.", e);
            }
        }
        MlBayesIm bnim = new MlBayesIm(bayesPm);
        if (probs == null) {
            return bnim;
        }
        for (int i = 0; i < probs.length; ++i) {
            Node childNode = dag.getNode(vars[i]);
            int nodeIndex = bnim.getNodeIndex(childNode);
            for (int j = 0; j < probs[i].length; ++j) {
                double prob;
                StringTokenizer st = new StringTokenizer(probs[i][j], "|");
                boolean areConds = st.countTokens() == 3;
                String childNodeValName = st.nextToken();
                String[] conds = new String[]{};
                if (areConds) {
                    StringTokenizer c = new StringTokenizer(st.nextToken(), ";");
                    conds = new String[c.countTokens()];
                    for (int q = 0; q < conds.length; ++q) {
                        conds[q] = c.nextToken();
                    }
                }
                try {
                    prob = Double.parseDouble(st.nextToken());
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Bad probability: " + nfe.toString());
                    return null;
                }
                int numParents = bnim.getNumParents(nodeIndex);
                int[] parVals = new int[numParents];
                Arrays.fill(parVals, -1);
                if (areConds) {
                    for (int k = 0; k < conds.length; ++k) {
                        StringTokenizer d = new StringTokenizer(conds[k], "=");
                        d.nextToken();
                        String valName = d.nextToken();
                        int parent = bnim.getParents(nodeIndex)[k];
                        parVals[k] = bayesPm.getCategoryIndex(bnim.getNode(parent), valName);
                    }
                }
                for (int parVal : parVals) {
                    if (parVal != -1) continue;
                    System.out.println("Incomplete specification.");
                    throw new IllegalArgumentException("Incomplete specification.");
                }
                int rowIndex = bnim.getRowIndex(nodeIndex, parVals);
                int colIndex = bayesPm.getCategoryIndex(childNode, childNodeValName);
                bnim.setProbability(nodeIndex, rowIndex, colIndex, prob);
            }
        }
        return bnim;
    }
}

