/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.Arrays;
import java.util.LinkedList;

public final class ModeInterpolator
implements DataFilter {
    @Override
    public DataSet filter(DataSet dataSet) {
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            Node variable = dataSet.getVariable(i);
            variables.add(variable);
        }
        ColtDataSet newDataSet = new ColtDataSet(dataSet.getNumRows(), variables);
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            Node var = dataSet.getVariable(j);
            if (var instanceof DiscreteVariable) {
                int i;
                DiscreteVariable variable = (DiscreteVariable)var;
                int numCategories = variable.getNumCategories();
                int[] categoryCounts = new int[numCategories];
                for (int i2 = 0; i2 < dataSet.getNumRows(); ++i2) {
                    if (dataSet.getInt(i2, j) == -99) continue;
                    int n = dataSet.getInt(i2, j);
                    categoryCounts[n] = categoryCounts[n] + 1;
                }
                int mode = -1;
                int max = -1;
                for (i = 0; i < numCategories; ++i) {
                    if (categoryCounts[i] <= max) continue;
                    max = categoryCounts[i];
                    mode = i;
                }
                for (i = 0; i < dataSet.getNumRows(); ++i) {
                    if (dataSet.getInt(i, j) == -99) {
                        newDataSet.setInt(i, j, mode);
                        continue;
                    }
                    newDataSet.setInt(i, j, dataSet.getInt(i, j));
                }
                continue;
            }
            if (!(dataSet.getVariable(j) instanceof ContinuousVariable)) continue;
            double[] data = new double[dataSet.getNumRows()];
            int k = -1;
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                if (Double.isNaN(dataSet.getDouble(i, j))) continue;
                data[++k] = dataSet.getDouble(i, j);
            }
            double mode = Double.NaN;
            if (k >= 0) {
                mode = (data[(k + 1) / 2] + data[k / 2]) / 2.0;
            }
            Arrays.sort(data);
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                if (Double.isNaN(dataSet.getDouble(i, j))) {
                    newDataSet.setDouble(i, j, mode);
                    continue;
                }
                newDataSet.setDouble(i, j, dataSet.getDouble(i, j));
            }
        }
        return newDataSet;
    }
}

