/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public final class Proposition
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private VariableSource variableSource;
    private boolean[][] allowedCategories;

    private Proposition(VariableSource variableSource) {
        if (variableSource == null) {
            throw new NullPointerException();
        }
        this.variableSource = variableSource;
        List<Node> variables = this.variableSource.getVariables();
        for (Node variable : variables) {
            if (variable instanceof DiscreteVariable) continue;
            throw new IllegalArgumentException("Variables for Propositions must be DiscreteVariables.");
        }
        this.allowedCategories = new boolean[variables.size()][];
        for (int i = 0; i < variables.size(); ++i) {
            DiscreteVariable discreteVariable = (DiscreteVariable)variables.get(i);
            int numCategories = discreteVariable.getNumCategories();
            this.allowedCategories[i] = new boolean[numCategories];
        }
        this.setToTautology();
    }

    public static Proposition tautology(VariableSource variableSource) {
        return new Proposition(variableSource);
    }

    public Proposition(VariableSource variableSource, Proposition proposition) {
        this(variableSource);
        if (proposition == null) {
            throw new NullPointerException();
        }
        List<Node> variables = variableSource.getVariables();
        List<Node> oldVariables = proposition.getVariableSource().getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            int j;
            DiscreteVariable variable = (DiscreteVariable)variables.get(i);
            int oldIndex = -1;
            for (j = 0; j < oldVariables.size(); ++j) {
                DiscreteVariable _variable = (DiscreteVariable)oldVariables.get(j);
                if (!variable.equals(_variable)) continue;
                oldIndex = j;
                break;
            }
            if (oldIndex == -1) continue;
            for (j = 0; j < this.allowedCategories[i].length; ++j) {
                this.allowedCategories[i][j] = proposition.isAllowed(oldIndex, j);
            }
        }
    }

    public Proposition(Proposition proposition) {
        this.variableSource = proposition.variableSource;
        this.allowedCategories = new boolean[proposition.allowedCategories.length][];
        for (int i = 0; i < this.allowedCategories.length; ++i) {
            this.allowedCategories[i] = new boolean[proposition.allowedCategories[i].length];
            System.arraycopy(proposition.allowedCategories[i], 0, this.allowedCategories[i], 0, this.allowedCategories[i].length);
        }
    }

    public static Proposition serializableInstance() {
        return new Proposition(MlBayesIm.serializableInstance());
    }

    public int getNumAllowedCategories(int i) {
        int numAllowed = 0;
        for (int j = 0; j < this.getNumCategories(i); ++j) {
            if (!this.isAllowed(i, j)) continue;
            ++numAllowed;
        }
        return numAllowed;
    }

    public void removeCategory(int variable, int category) {
        this.allowedCategories[variable][category] = false;
    }

    public void disallowComplement(int variable, int category) {
        for (int i = 0; i < this.allowedCategories[variable].length; ++i) {
            if (i == category) continue;
            this.allowedCategories[variable][i] = false;
        }
    }

    public void setCategory(int variable, int category) {
        this.setVariable(variable, false);
        this.addCategory(variable, category);
    }

    public boolean isUnconditioned(int variable) {
        return !this.isConditioned(variable);
    }

    public boolean isPermissibleCombination(int[] point) {
        for (int i = 0; i < this.allowedCategories.length; ++i) {
            if (this.allowedCategories[i][point[i]]) continue;
            return false;
        }
        return true;
    }

    public boolean existsCombination() {
        boolean[][] arr$ = this.allowedCategories;
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            boolean[] allowedCategory;
            for (boolean anAllowedCategory : allowedCategory = arr$[i$]) {
                if (anAllowedCategory) continue block0;
            }
            return false;
        }
        return true;
    }

    public int getNumAllowed(int variable) {
        int sum = 0;
        for (int i = 0; i < this.getNumCategories(variable); ++i) {
            if (!this.isAllowed(variable, i)) continue;
            ++sum;
        }
        return sum;
    }

    public int getSingleCategory(int variable) {
        int count = 0;
        int lastEncountered = -1;
        for (int i = 0; i < this.allowedCategories[variable].length; ++i) {
            if (!this.allowedCategories[variable][i]) continue;
            lastEncountered = i;
            ++count;
        }
        if (count != 1) {
            return -1;
        }
        return lastEncountered;
    }

    public void restrictToProposition(Proposition proposition) {
        if (proposition.getVariableSource() != this.variableSource) {
            throw new IllegalArgumentException("Can only restrict to propositions for the same variable source.");
        }
        for (int i = 0; i < this.allowedCategories.length; ++i) {
            for (int j = 0; j < this.allowedCategories[i].length; ++j) {
                if (proposition.allowedCategories[i][j]) continue;
                this.allowedCategories[i][j] = false;
            }
        }
    }

    public void restrictToProposition(Proposition proposition, int variable) {
        if (proposition.getVariableSource() != this.variableSource) {
            throw new IllegalArgumentException("Can only restrict to propositions for the same variable source.");
        }
        for (int j = 0; j < this.allowedCategories[variable].length; ++j) {
            if (proposition.isAllowed(variable, j)) continue;
            this.removeCategory(variable, j);
        }
    }

    public int getNodeIndex(String name) {
        List<Node> variables = this.getVariableSource().getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            Node variable = variables.get(i);
            if (!variable.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getCategoryIndex(String nodeName, String category) {
        int index = this.getVariableSource().getVariableNames().indexOf(nodeName);
        DiscreteVariable variable = (DiscreteVariable)this.getVariableSource().getVariables().get(index);
        return variable.getCategories().indexOf(category);
    }

    public void addCategory(int variable, int category) {
        this.allowedCategories[variable][category] = true;
    }

    public VariableSource getVariableSource() {
        return this.variableSource;
    }

    public int getNumVariables() {
        return this.allowedCategories.length;
    }

    public int getNumCategories(int variable) {
        return this.allowedCategories[variable].length;
    }

    public void setVariable(int variable, boolean allowed) {
        for (int i = 0; i < this.allowedCategories[variable].length; ++i) {
            this.allowedCategories[variable][i] = allowed;
        }
    }

    public void setToTautology() {
        for (int i = 0; i < this.allowedCategories.length; ++i) {
            this.setVariable(i, true);
        }
    }

    public boolean isAllowed(int variable, int category) {
        return this.allowedCategories[variable][category];
    }

    public boolean isConditioned(int variable) {
        for (int j = 0; j < this.getNumCategories(variable); ++j) {
            if (this.isAllowed(variable, j)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Proposition proposition = (Proposition)o;
        if (this.variableSource != proposition.variableSource) {
            return false;
        }
        for (int i = 0; i < this.allowedCategories.length; ++i) {
            for (int j = 0; j < this.allowedCategories[i].length; ++j) {
                if (this.allowedCategories[i][j] == proposition.allowedCategories[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 19 * hashCode + this.variableSource.hashCode();
        hashCode = 19 * hashCode + this.allowedCategories.hashCode();
        return hashCode;
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        List<Node> variables = this.getVariableSource().getVariables();
        buf.append("\n");
        for (i = 0; i < this.getNumVariables(); ++i) {
            DiscreteVariable variable = (DiscreteVariable)variables.get(i);
            String name = variable.getName();
            buf.append(name);
            for (int j = name.length(); j < 5; ++j) {
                buf.append(" ");
            }
            buf.append("\t");
        }
        for (i = 0; i < this.getMaxNumCategories(); ++i) {
            buf.append("\n");
            for (int j = 0; j < this.getNumVariables(); ++j) {
                if (i < this.getNumCategories(j)) {
                    boolean allowed = this.isAllowed(j, i);
                    buf.append(allowed ? "true" : "*   ").append("\t");
                    continue;
                }
                buf.append("    \t");
            }
        }
        return buf.toString();
    }

    private int getMaxNumCategories() {
        int max = 0;
        for (int i = 0; i < this.getNumVariables(); ++i) {
            if (this.getNumCategories(i) <= max) continue;
            max = this.getNumCategories(i);
        }
        return max;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.variableSource == null) {
            throw new NullPointerException();
        }
        if (this.allowedCategories == null) {
            throw new NullPointerException();
        }
    }
}

