/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BdeMetricCache;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestBDeMetricCache
extends TestCase {
    public TestBDeMetricCache(String name) {
        super(name);
    }

    public static void testFB_SEM() {
        try {
            String fileName = "test_data/testbdemetricX1X2X310k.dat";
            File file = new File(fileName);
            DataReader reader = new DataReader();
            DataSet ds = reader.parseTabular(file);
            GraphNode x1 = new GraphNode("X1");
            GraphNode x2 = new GraphNode("X2");
            GraphNode x3 = new GraphNode("X3");
            GraphNode x4 = new GraphNode("X4");
            GraphNode x5 = new GraphNode("X5");
            Dag graph = new Dag();
            graph.clear();
            graph.addNode(x1);
            graph.addNode(x2);
            graph.addNode(x3);
            graph.addNode(x4);
            graph.addNode(x5);
            graph.addDirectedEdge(x1, x2);
            graph.addDirectedEdge(x2, x3);
            graph.addDirectedEdge(x3, x4);
            BayesPm bayesPm = new BayesPm(graph);
            bayesPm.setNumCategories(x1, 2);
            bayesPm.setNumCategories(x2, 2);
            bayesPm.setNumCategories(x3, 2);
            bayesPm.setNumCategories(x4, 2);
            bayesPm.setNumCategories(x5, 2);
            BdeMetricCache bdemc = new BdeMetricCache(ds, bayesPm);
            HashSet<Node> s1 = new HashSet<Node>();
            s1.add(x2);
            s1.add(x3);
            int c1 = bdemc.getScoreCount(x1, s1);
            TestBDeMetricCache.assertEquals(c1, 3);
            HashSet<Node> s2 = new HashSet<Node>();
            s2.add(x3);
            int c2 = bdemc.getScoreCount(x4, s2);
            TestBDeMetricCache.assertEquals(c2, 2);
            HashSet<Node> s3 = new HashSet<Node>();
            s3.add(x2);
            s3.add(x3);
            int c3 = bdemc.getScoreCount(x1, s3);
            TestBDeMetricCache.assertEquals(c3, 3);
            System.out.println("c1, c2, c3 = " + c1 + " " + c2 + " " + c3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestBDeMetricCache.class);
    }
}

