/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.GraphNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestBayesIm
extends TestCase {
    public TestBayesIm(String name) {
        super(name);
    }

    public static void testConstructRandom() {
        System.out.println("\n\nTest construct random.");
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        System.out.println(bayesIm);
    }

    public static void testCopyConstructor() {
        System.out.println("\n\nTest copy constructor.");
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        MlBayesIm bayesIm2 = new MlBayesIm(bayesIm);
        TestBayesIm.assertEquals(bayesIm, bayesIm2);
    }

    public static void testConstructManual() {
        System.out.println("\n\nTest construct manual.");
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm);
        System.out.println(bayesIm);
    }

    public static void testAddRemoveParent() {
        System.out.println("\n\nTest add and remove parent.");
        GraphNode a = new GraphNode("a");
        GraphNode b = new GraphNode("b");
        Dag dag = new Dag();
        dag.addNode(a);
        dag.addNode(b);
        dag.addDirectedEdge(a, b);
        BayesPm bayesPm = new BayesPm(dag);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        System.out.println(bayesIm);
        MlBayesIm bayesIm2 = new MlBayesIm(bayesPm, bayesIm, 0);
        System.out.println(bayesIm2);
        TestBayesIm.assertEquals(bayesIm, bayesIm2);
        GraphNode c = new GraphNode("c");
        dag.addNode(c);
        dag.addDirectedEdge(c, b);
        System.out.println("dag = " + dag);
        BayesPm bayesPm3 = new BayesPm(dag, bayesPm);
        MlBayesIm bayesIm3 = new MlBayesIm(bayesPm3, bayesIm2, 0);
        System.out.println("bayesIm3 = " + bayesIm3);
        TestBayesIm.assertTrue(TestBayesIm.rowsEqual(bayesIm3, bayesIm3.getNodeIndex(b), 0, 1));
        TestBayesIm.assertTrue(!TestBayesIm.rowsEqual(bayesIm3, bayesIm3.getNodeIndex(b), 1, 2));
        TestBayesIm.assertTrue(TestBayesIm.rowsEqual(bayesIm3, bayesIm3.getNodeIndex(b), 2, 3));
        TestBayesIm.assertTrue(TestBayesIm.rowUnspecified(bayesIm3, bayesIm3.getNodeIndex(c), 0));
        dag.removeNode(c);
        BayesPm bayesPm4 = new BayesPm(dag, bayesPm3);
        MlBayesIm bayesIm4 = new MlBayesIm(bayesPm4, bayesIm3, 0);
        System.out.println("bayesIm4 = " + bayesIm4);
        TestBayesIm.assertTrue(bayesIm4.getNumRows(bayesIm4.getNodeIndex(b)) == 2);
        TestBayesIm.assertTrue(TestBayesIm.rowUnspecified(bayesIm4, bayesIm4.getNodeIndex(b), 0));
        TestBayesIm.assertTrue(TestBayesIm.rowUnspecified(bayesIm4, bayesIm4.getNodeIndex(b), 1));
    }

    public static void testAddRemoveValues() {
        System.out.println("\n\nTest retain old values.");
        GraphNode a = new GraphNode("a");
        GraphNode b = new GraphNode("b");
        GraphNode c = new GraphNode("c");
        Dag dag = new Dag();
        dag.addNode(a);
        dag.addNode(b);
        dag.addNode(c);
        dag.addDirectedEdge(a, b);
        dag.addDirectedEdge(c, b);
        TestBayesIm.assertTrue(Edges.isDirectedEdge(dag.getEdge(a, b)));
        BayesPm bayesPm = new BayesPm(dag, 3, 3);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        System.out.println(bayesIm);
        bayesPm.setNumCategories(a, 4);
        bayesPm.setNumCategories(c, 4);
        MlBayesIm bayesIm2 = new MlBayesIm(bayesPm, bayesIm, 0);
        System.out.println(bayesIm2);
        bayesPm.setNumCategories(a, 2);
        MlBayesIm bayesIm3 = new MlBayesIm(bayesPm, bayesIm2, 0);
        System.out.println(bayesIm3);
        bayesPm.setNumCategories(b, 2);
        MlBayesIm bayesIm4 = new MlBayesIm(bayesPm, 1);
        for (int node = 0; node < bayesIm4.getNumNodes(); ++node) {
            for (int row = 0; row < bayesIm4.getNumRows(node); ++row) {
                for (int col = 0; col < bayesIm4.getNumColumns(node); ++col) {
                    bayesIm4.setProbability(node, row, col, Double.NaN);
                }
            }
        }
        System.out.println(bayesIm4);
        double[][] aTable = new double[][]{{0.2, 0.8}};
        double[][] bTable = new double[][]{{0.1, 0.9}, {0.7, 0.3}, {0.3, 0.7}, {0.5, 0.5}, {0.09, 0.91}, {0.6, 0.4}, {0.2, 0.8}, {0.8, 0.2}};
        double[][] cTable = new double[][]{{0.1, 0.2, 0.3, 0.4}};
        int _a = bayesIm.getNodeIndex(a);
        for (int row = 0; row < bayesIm4.getNumRows(_a); ++row) {
            for (int col = 0; col < bayesIm4.getNumColumns(_a); ++col) {
                bayesIm4.setProbability(_a, row, col, aTable[row][col]);
            }
        }
        int _b = bayesIm.getNodeIndex(b);
        for (int row = 0; row < bayesIm4.getNumRows(_b); ++row) {
            for (int col = 0; col < bayesIm4.getNumColumns(_b); ++col) {
                bayesIm4.setProbability(_b, row, col, bTable[row][col]);
            }
        }
        int _c = bayesIm.getNodeIndex(c);
        for (int row = 0; row < bayesIm4.getNumRows(_c); ++row) {
            for (int col = 0; col < bayesIm4.getNumColumns(_c); ++col) {
                bayesIm4.setProbability(_c, row, col, cTable[row][col]);
            }
        }
        System.out.println(bayesIm4);
    }

    private static boolean rowsEqual(BayesIm bayesIm, int node, int row1, int row2) {
        for (int col = 0; col < bayesIm.getNumColumns(node); ++col) {
            double prob2;
            double prob1 = bayesIm.getProbability(node, row1, col);
            if (prob1 == (prob2 = bayesIm.getProbability(node, row2, col))) continue;
            return false;
        }
        return true;
    }

    private static boolean rowUnspecified(BayesIm bayesIm, int node, int row) {
        for (int col = 0; col < bayesIm.getNumColumns(node); ++col) {
            double prob = bayesIm.getProbability(node, row, col);
            if (Double.isNaN(prob)) continue;
            return false;
        }
        return true;
    }

    public static Test suite() {
        return new TestSuite(TestBayesIm.class);
    }
}

