/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestEvidence
extends TestCase {
    public TestEvidence(String name) {
        super(name);
    }

    public static void testUpdate1() {
        BayesIm bayesIm = TestEvidence.sampleBayesIm2();
        Evidence evidence = Evidence.tautology(bayesIm);
        System.out.println(evidence);
        evidence.getProposition().removeCategory(0, 1);
        System.out.println(evidence);
        evidence.getProposition().setVariable(1, false);
        evidence.setManipulated(0, true);
        System.out.println(evidence);
        Evidence evidence2 = new Evidence(evidence, bayesIm);
        System.out.println("Copied evidence:");
        System.out.println(evidence2);
        TestEvidence.assertEquals(evidence2, evidence);
        MlBayesIm bayesIm2 = new MlBayesIm(bayesIm);
        Evidence evidence3 = new Evidence(evidence, bayesIm2);
        TestEvidence.assertTrue(!evidence3.equals(evidence2));
    }

    private static BayesIm sampleBayesIm2() {
        GraphNode a = new GraphNode("a");
        GraphNode b = new GraphNode("b");
        GraphNode c = new GraphNode("c");
        Dag graph = new Dag();
        graph.addNode(a);
        graph.addNode(b);
        graph.addNode(c);
        graph.addDirectedEdge(a, b);
        graph.addDirectedEdge(a, c);
        graph.addDirectedEdge(b, c);
        BayesPm bayesPm = new BayesPm(graph);
        bayesPm.setNumCategories(b, 3);
        MlBayesIm bayesIm1 = new MlBayesIm(bayesPm);
        bayesIm1.setProbability(0, 0, 0, 0.3);
        bayesIm1.setProbability(0, 0, 1, 0.7);
        bayesIm1.setProbability(1, 0, 0, 0.3);
        bayesIm1.setProbability(1, 0, 1, 0.4);
        bayesIm1.setProbability(1, 0, 2, 0.3);
        bayesIm1.setProbability(1, 1, 0, 0.6);
        bayesIm1.setProbability(1, 1, 1, 0.1);
        bayesIm1.setProbability(1, 1, 2, 0.3);
        bayesIm1.setProbability(2, 0, 0, 0.9);
        bayesIm1.setProbability(2, 0, 1, 0.1);
        bayesIm1.setProbability(2, 1, 0, 0.1);
        bayesIm1.setProbability(2, 1, 1, 0.9);
        bayesIm1.setProbability(2, 2, 0, 0.5);
        bayesIm1.setProbability(2, 2, 1, 0.5);
        bayesIm1.setProbability(2, 3, 0, 0.2);
        bayesIm1.setProbability(2, 3, 1, 0.8);
        bayesIm1.setProbability(2, 4, 0, 0.6);
        bayesIm1.setProbability(2, 4, 1, 0.4);
        bayesIm1.setProbability(2, 5, 0, 0.7);
        bayesIm1.setProbability(2, 5, 1, 0.3);
        return bayesIm1;
    }

    public static Test suite() {
        return new TestSuite(TestEvidence.class);
    }
}

