/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.FactoredBayesStructuralEM;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestFactoredBayesSemMd
extends TestCase {
    public TestFactoredBayesSemMd(String name) {
        super(name);
    }

    public static void testNothing() {
    }

    public static void rtestFbSemOrig() {
        try {
            String fileName = "test_data/l1x1x2x3nolatent.dat";
            File file = new File(fileName);
            DataReader reader = new DataReader();
            reader.setMissingValueMarker("-99");
            DataSet ds = reader.parseTabular(file);
            GraphNode l1 = new GraphNode("L1");
            GraphNode x1 = new GraphNode("X1");
            GraphNode x2 = new GraphNode("X2");
            GraphNode x3 = new GraphNode("X3");
            l1.setNodeType(NodeType.MEASURED);
            x1.setNodeType(NodeType.MEASURED);
            x2.setNodeType(NodeType.MEASURED);
            x3.setNodeType(NodeType.MEASURED);
            Dag graph = new Dag();
            graph.addNode(l1);
            graph.addNode(x1);
            graph.addNode(x2);
            graph.addNode(x3);
            BayesPm bayesPm = new BayesPm(graph);
            bayesPm.setNumCategories(l1, 2);
            bayesPm.setNumCategories(x1, 2);
            bayesPm.setNumCategories(x2, 2);
            bayesPm.setNumCategories(x3, 2);
            FactoredBayesStructuralEM fbsem = new FactoredBayesStructuralEM(ds, bayesPm);
            BayesIm bestIm = fbsem.iterate();
            BayesPm bestPm = bestIm.getBayesPm();
            System.out.println("Graph of best model (output of FactoredBayesStructuralEM):  ");
            Dag bestGraph = bestPm.getDag();
            System.out.println(bestGraph);
            System.out.println(bestPm);
            Dag genGraph = new Dag();
            genGraph.clear();
            genGraph.addNode(l1);
            genGraph.addNode(x1);
            genGraph.addNode(x2);
            genGraph.addNode(x3);
            genGraph.addDirectedEdge(x1, l1);
            genGraph.addDirectedEdge(x2, x1);
            genGraph.addDirectedEdge(l1, x3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void rtestFbSemMdw() {
        try {
            String fileName = "test_data/structEM_MDW4000.dat";
            File file = new File(fileName);
            DataReader reader = new DataReader();
            reader.setMissingValueMarker("-99");
            DataSet dds = reader.parseTabular(file);
            double[] probs = new double[]{0.05, 0.05, 0.05, 0.05, 0.05};
            dds = DataUtils.addMissingData(dds, probs);
            GraphNode A = new GraphNode("A");
            GraphNode B = new GraphNode("B");
            GraphNode C = new GraphNode("C");
            GraphNode X = new GraphNode("X");
            GraphNode Y = new GraphNode("Y");
            A.setNodeType(NodeType.MEASURED);
            B.setNodeType(NodeType.MEASURED);
            C.setNodeType(NodeType.MEASURED);
            X.setNodeType(NodeType.MEASURED);
            Y.setNodeType(NodeType.MEASURED);
            Dag graph = new Dag();
            graph.addNode(A);
            graph.addNode(B);
            graph.addNode(C);
            graph.addNode(X);
            graph.addNode(Y);
            BayesPm bayesPm = new BayesPm(graph);
            bayesPm.setNumCategories(A, 2);
            bayesPm.setNumCategories(B, 2);
            bayesPm.setNumCategories(C, 2);
            bayesPm.setNumCategories(X, 2);
            bayesPm.setNumCategories(Y, 2);
            FactoredBayesStructuralEM fbsem = new FactoredBayesStructuralEM(dds, bayesPm);
            BayesIm bestIm = fbsem.maximization(1.0E-4);
            BayesPm bestPm = bestIm.getBayesPm();
            System.out.println("Graph of best model (output of FactoredBayesStructuralEM):  ");
            Dag bestGraph = bestPm.getDag();
            System.out.println(bestGraph);
            System.out.println(bestPm);
            Dag genGraph = new Dag();
            genGraph.clear();
            GraphNode Ac = new GraphNode("A");
            GraphNode Bc = new GraphNode("B");
            GraphNode Cc = new GraphNode("C");
            GraphNode Xc = new GraphNode("X");
            GraphNode Yc = new GraphNode("Y");
            genGraph.addNode(Ac);
            genGraph.addNode(Bc);
            genGraph.addNode(Cc);
            genGraph.addNode(Xc);
            genGraph.addNode(Yc);
            genGraph.addDirectedEdge(Ac, Bc);
            genGraph.addDirectedEdge(Ac, Xc);
            genGraph.addDirectedEdge(Bc, Xc);
            genGraph.addDirectedEdge(Bc, Cc);
            genGraph.addDirectedEdge(Yc, Bc);
            genGraph.addDirectedEdge(Yc, Cc);
            genGraph.addDirectedEdge(Yc, Xc);
            TestFactoredBayesSemMd.assertEquals(genGraph, bestGraph);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void rtestFbSemMdab() {
        try {
            String fileName = "test_data/structEM_ABMD.dat";
            File file = new File(fileName);
            DataReader reader = new DataReader();
            reader.setMissingValueMarker("-99");
            DataSet ds = reader.parseTabular(file);
            GraphNode A = new GraphNode("A");
            GraphNode B = new GraphNode("B");
            A.setNodeType(NodeType.MEASURED);
            B.setNodeType(NodeType.MEASURED);
            Dag graph = new Dag();
            graph.clear();
            graph.addNode(A);
            graph.addNode(B);
            BayesPm bayesPm = new BayesPm(graph);
            bayesPm.setNumCategories(A, 2);
            bayesPm.setNumCategories(B, 2);
            FactoredBayesStructuralEM fbsem = new FactoredBayesStructuralEM(ds, bayesPm);
            BayesIm bestIm = fbsem.iterate();
            BayesPm bestPm = bestIm.getBayesPm();
            System.out.println("Graph of best model (output of FactoredBayesStructuralEM):  ");
            Dag bestGraph = bestPm.getDag();
            System.out.println(bestGraph);
            System.out.println(bestPm);
            Dag genGraph = new Dag();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void rtestFbSemMdy() {
        try {
            String fileName = "test_data/structEM_MDY.dat";
            File file = new File(fileName);
            DataReader reader = new DataReader();
            reader.setMissingValueMarker("-99");
            DataSet ds = reader.parseTabular(file);
            GraphNode X = new GraphNode("X");
            GraphNode Y = new GraphNode("Y");
            GraphNode Z = new GraphNode("Z");
            GraphNode W = new GraphNode("W");
            X.setNodeType(NodeType.MEASURED);
            Y.setNodeType(NodeType.MEASURED);
            Z.setNodeType(NodeType.MEASURED);
            W.setNodeType(NodeType.MEASURED);
            Dag graph = new Dag();
            graph.clear();
            graph.addNode(X);
            graph.addNode(Y);
            graph.addNode(Z);
            graph.addNode(W);
            BayesPm bayesPm = new BayesPm(graph);
            bayesPm.setNumCategories(X, 2);
            bayesPm.setNumCategories(Y, 2);
            bayesPm.setNumCategories(Z, 2);
            bayesPm.setNumCategories(W, 2);
            FactoredBayesStructuralEM fbsem = new FactoredBayesStructuralEM(ds, bayesPm);
            BayesIm bestIm = fbsem.iterate();
            BayesPm bestPm = bestIm.getBayesPm();
            System.out.println("Graph of best model (output of FactoredBayesStructuralEM):  ");
            Dag bestGraph = bestPm.getDag();
            System.out.println(bestGraph);
            System.out.println(bestPm);
            Dag genGraph = new Dag();
            genGraph.clear();
            genGraph.addNode(X);
            genGraph.addNode(Y);
            genGraph.addNode(Z);
            genGraph.addNode(W);
            genGraph.addDirectedEdge(W, Z);
            TestFactoredBayesSemMd.assertEquals(genGraph, bestGraph);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestFactoredBayesSemMd.class);
    }
}

