/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.FactoredBayesStructuralEM;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestFactoredScoreCacheMd
extends TestCase {
    public TestFactoredScoreCacheMd(String name) {
        super(name);
    }

    public static void testNothing() {
    }

    public static void rtestFbSem() {
        try {
            String fileName = "test_data/l1x1x2x3nolatent.dat";
            File file = new File(fileName);
            DataReader reader = new DataReader();
            reader.setDelimiter(DelimiterType.COMMA);
            reader.setCommentMarker("#");
            DataSet ds = reader.parseTabular(file);
            GraphNode l1 = new GraphNode("L1");
            GraphNode x1 = new GraphNode("X1");
            GraphNode x2 = new GraphNode("X2");
            GraphNode x3 = new GraphNode("X3");
            l1.setNodeType(NodeType.MEASURED);
            x1.setNodeType(NodeType.MEASURED);
            x2.setNodeType(NodeType.MEASURED);
            x3.setNodeType(NodeType.MEASURED);
            Dag graph = new Dag();
            graph.clear();
            graph.addNode(l1);
            graph.addNode(x1);
            graph.addNode(x2);
            graph.addNode(x3);
            BayesPm bayesPm = new BayesPm(graph);
            bayesPm.setNumCategories(l1, 2);
            bayesPm.setNumCategories(x1, 2);
            bayesPm.setNumCategories(x2, 2);
            bayesPm.setNumCategories(x3, 2);
            FactoredBayesStructuralEM fbsem = new FactoredBayesStructuralEM(ds, bayesPm);
            fbsem.scoreTest();
            Dag genGraph = new Dag();
            genGraph.clear();
            genGraph.addNode(l1);
            genGraph.addNode(x1);
            genGraph.addNode(x2);
            genGraph.addNode(x3);
            genGraph.addDirectedEdge(x1, l1);
            genGraph.addDirectedEdge(x2, x1);
            genGraph.addDirectedEdge(l1, x3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testFB_SEM_MDW() {
        GraphNode A = new GraphNode("A");
        GraphNode B = new GraphNode("B");
        GraphNode C = new GraphNode("C");
        GraphNode X = new GraphNode("X");
        GraphNode Y = new GraphNode("Y");
        A.setNodeType(NodeType.MEASURED);
        B.setNodeType(NodeType.MEASURED);
        C.setNodeType(NodeType.MEASURED);
        X.setNodeType(NodeType.MEASURED);
        Y.setNodeType(NodeType.MEASURED);
        Dag graph = new Dag();
        graph.clear();
        graph.addNode(A);
        graph.addNode(B);
        graph.addNode(C);
        graph.addNode(X);
        graph.addNode(Y);
        BayesPm bayesPm = new BayesPm(graph);
        bayesPm.setNumCategories(A, 2);
        bayesPm.setNumCategories(B, 2);
        bayesPm.setNumCategories(C, 2);
        bayesPm.setNumCategories(X, 2);
        bayesPm.setNumCategories(Y, 2);
        Dag genGraph = new Dag(graph);
        genGraph.addDirectedEdge(A, X);
        genGraph.addDirectedEdge(B, X);
        genGraph.addDirectedEdge(B, Y);
        genGraph.addDirectedEdge(C, Y);
    }

    public static Test suite() {
        return new TestSuite(TestFactoredScoreCacheMd.class);
    }
}

