/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.cluster.metrics.Dissimilarity;
import edu.cmu.tetrad.cluster.metrics.SquaredErrorLoss;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Cast
implements ClusteringAlgorithm {
    private Dissimilarity dissimilarity = new SquaredErrorLoss();
    private double threshold = 1.0;
    private List<List<Integer>> clusters;
    private boolean verbose = true;
    private Set<Integer> storedCluster;
    private double[] affinities;

    @Override
    public void cluster(DoubleMatrix2D data) {
        ArrayList<List<Integer>> clusters = new ArrayList<List<Integer>>();
        LinkedHashSet<Integer> setU = new LinkedHashSet<Integer>();
        for (int i = 0; i < data.rows(); ++i) {
            setU.add(i);
        }
        LinkedHashSet<Integer> cOpen = new LinkedHashSet<Integer>();
        this.affinities = new double[data.rows()];
        while (!setU.isEmpty() || !cOpen.isEmpty()) {
            int u = this.maximalAffinity(setU, cOpen, data);
            if (u != -1 && this.affinity(u, cOpen, data) <= this.getThreshold() * (double)cOpen.size()) {
                cOpen.add(u);
                setU.remove(u);
                System.out.println("Adding " + u + " affinity = " + this.affinity(u, cOpen, data) + " <= " + this.getThreshold() + " * " + cOpen.size() + " = " + this.getThreshold() * (double)cOpen.size());
                this.adjustAffinitiesUp(u, data);
                continue;
            }
            int v = this.minimalAffinity(cOpen, data);
            if (v != -1 && this.affinity(v, cOpen, data) > this.getThreshold() * (double)(cOpen.size() - 1)) {
                System.out.println("Removing " + v + " affinity = " + this.affinity(v, cOpen, data) + " > " + this.getThreshold() + " * " + (cOpen.size() - 1) + " = " + this.getThreshold() * (double)(cOpen.size() - 1));
                cOpen.remove(v);
                setU.add(v);
                this.adjustAffinitiesDown(v, data);
                continue;
            }
            System.out.println("Closing: size = " + cOpen.size());
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            clusters.add(new ArrayList<Integer>(cOpen));
            cOpen = new LinkedHashSet();
            for (int i = 0; i < data.rows(); ++i) {
                this.affinities[i] = 0.0;
            }
        }
        this.clusters = clusters;
    }

    private void adjustAffinitiesUp(int u, DoubleMatrix2D data) {
        DoubleMatrix1D v1 = data.viewRow(u);
        int x = 0;
        while (x < data.rows()) {
            DoubleMatrix1D v2 = data.viewRow(x);
            int n = x++;
            this.affinities[n] = this.affinities[n] + this.similarity(v1, v2);
        }
    }

    private void adjustAffinitiesDown(int u, DoubleMatrix2D data) {
        DoubleMatrix1D v1 = data.viewRow(u);
        int x = 0;
        while (x < data.rows()) {
            DoubleMatrix1D v2 = data.viewRow(x);
            int n = x++;
            this.affinities[n] = this.affinities[n] - this.similarity(v1, v2);
        }
    }

    @Override
    public List<List<Integer>> getClusters() {
        return this.clusters;
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private int minimalAffinity(Set<Integer> set, DoubleMatrix2D data) {
        int p = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int p2 : set) {
            double affinity = this.affinity(p2, set, data);
            if (!(affinity > max)) continue;
            max = affinity;
            p = p2;
        }
        return p;
    }

    private int maximalAffinity(Set<Integer> set, Set<Integer> cOpen, DoubleMatrix2D data) {
        int p = -1;
        double min = Double.POSITIVE_INFINITY;
        for (int p2 : set) {
            double affinity = this.affinity(p2, cOpen, data);
            if (!(affinity < min)) continue;
            min = affinity;
            p = p2;
        }
        return p;
    }

    private double affinity(int point, Set<Integer> cluster, DoubleMatrix2D data) {
        if (this.affinities[point] == 0.0) {
            this.affinities[point] = this.affinity2(point, cluster, data);
        }
        return this.affinities[point];
    }

    private double affinity2(int point, Set<Integer> cluster, DoubleMatrix2D data) {
        double sum = 0.0;
        for (int otherPoint : cluster) {
            if (point == otherPoint) continue;
            DoubleMatrix1D v1 = data.viewRow(point);
            DoubleMatrix1D v2 = data.viewRow(otherPoint);
            sum += this.similarity(v1, v2);
        }
        return sum;
    }

    private double similarity(DoubleMatrix1D v1, DoubleMatrix1D v2) {
        return this.getDissimilarity().dissimilarity(v1, v2);
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public Dissimilarity getDissimilarity() {
        return this.dissimilarity;
    }

    public void setDissimilarity(Dissimilarity dissimilarity) {
        this.dissimilarity = dissimilarity;
    }
}

