/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.util.StatUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class Cba
implements ClusteringAlgorithm {
    private DoubleMatrix2D xyzCoords;
    private boolean verbose = true;
    private List<List<Integer>> clusters;

    public Cba(DoubleMatrix2D xyzCoords) {
        this.xyzCoords = xyzCoords;
    }

    @Override
    public void cluster(DoubleMatrix2D timeSeries) {
        int i;
        int z;
        int y;
        int x;
        DoubleArrayList cluster0 = new DoubleArrayList(this.xyzCoords.viewColumn(0).toArray());
        DoubleArrayList cluster1 = new DoubleArrayList(this.xyzCoords.viewColumn(1).toArray());
        DoubleArrayList cluster2 = new DoubleArrayList(this.xyzCoords.viewColumn(2).toArray());
        int minX = (int)Descriptive.min(cluster0);
        int minY = (int)Descriptive.min(cluster1);
        int minZ = (int)Descriptive.min(cluster2);
        int maxX = (int)Descriptive.max(cluster0);
        int maxY = (int)Descriptive.max(cluster1);
        int maxZ = (int)Descriptive.max(cluster2);
        double mean0 = Descriptive.mean(cluster0);
        double mean1 = Descriptive.mean(cluster1);
        double mean2 = Descriptive.mean(cluster2);
        double sd0 = this.standardDeviation(cluster0);
        double sd1 = this.standardDeviation(cluster1);
        double sd2 = this.standardDeviation(cluster2);
        System.out.println("X = " + minX + " to " + maxX + " mean = " + mean0 + " SD = " + sd0);
        System.out.println("Y = " + minY + " to " + maxY + " mean = " + mean1 + " SD = " + sd1);
        System.out.println("Z = " + minZ + " to " + maxZ + " mean = " + mean2 + " SD = " + sd2);
        int[][][] brainMap = new int[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    brainMap[x2 - minX][y2 - minY][z2 - minZ] = -1;
                }
            }
        }
        int i2 = 0;
        while (i2 < this.xyzCoords.rows()) {
            x = (int)this.xyzCoords.get(i2, 0);
            if (brainMap[x - minX][(y = (int)this.xyzCoords.get(i2, 1)) - minY][(z = (int)this.xyzCoords.get(i2, 2)) - minZ] != -1) {
                System.out.println("Duplicate coordinates: <" + x + ", " + y + ", " + z + ">");
            }
            brainMap[x - minX][y - minY][z - minZ] = i2++;
        }
        ArrayList protoClusters = new ArrayList();
        for (i = 0; i < this.xyzCoords.rows(); ++i) {
            protoClusters.add(null);
        }
        for (x = minX; x <= maxX; ++x) {
            System.out.println("x = " + x);
            for (y = minY; y <= maxY; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    int i1 = brainMap[x - minX][y - minY][z - minZ];
                    if (i1 == -1) continue;
                    double d = Double.NEGATIVE_INFINITY;
                    int foundX = -1;
                    int foundY = -1;
                    int foundZ = -1;
                    for (int _x = x - 1; _x <= x + 1; ++_x) {
                        for (int _y = y - 1; _y <= y + 1; ++_y) {
                            for (int _z = z - 1; _z <= z + 1; ++_z) {
                                double v;
                                int i22;
                                if (_x < minX || _x > maxX || _y < minY || _y > maxY || _z < minZ || _z > maxZ || _x == x && _y == y && _z == z || (i22 = brainMap[_x - minX][_y - minY][_z - minZ]) == -1 || !((v = StatUtils.correlation(timeSeries.viewRow(i1).toArray(), timeSeries.viewRow(i22).toArray())) > d)) continue;
                                d = v;
                                foundX = _x;
                                foundY = _y;
                                foundZ = _z;
                            }
                        }
                    }
                    if (foundX == -1 || foundY == -1 || foundZ == -1) continue;
                    int centerPoint = brainMap[x - minX][y - minY][z - minZ];
                    int otherPoint = brainMap[foundX - minX][foundY - minY][foundZ - minZ];
                    LinkedList<Integer> cluster = new LinkedList<Integer>();
                    cluster.add(centerPoint);
                    cluster.add(otherPoint);
                    protoClusters.set(centerPoint, cluster);
                }
            }
        }
        for (i = 0; i < protoClusters.size(); ++i) {
            List cluster = (List)protoClusters.get(i);
            if (cluster == null || cluster.size() == 1) continue;
            Integer reference = (Integer)cluster.get(1);
            List _cluster = (List)protoClusters.get(reference);
            while (_cluster.size() == 1) {
                reference = (Integer)_cluster.get(0);
                _cluster = (List)protoClusters.get(reference);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            linkedHashSet.addAll(_cluster);
            linkedHashSet.addAll(cluster);
            LinkedList newCluster = new LinkedList(linkedHashSet);
            protoClusters.set(reference, newCluster);
            cluster.clear();
            cluster.add(reference);
        }
        ArrayList<List<Integer>> clusters = new ArrayList<List<Integer>>();
        int minSize = Integer.MAX_VALUE;
        int maxSize = Integer.MIN_VALUE;
        for (List list : protoClusters) {
            if (list == null || list.size() < 2) continue;
            clusters.add(list);
            if (list.size() < minSize) {
                minSize = list.size();
            }
            if (list.size() <= maxSize) continue;
            maxSize = list.size();
        }
        this.clusters = clusters;
    }

    @Override
    public List<List<Integer>> getClusters() {
        return this.clusters;
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        return null;
    }

    private double distance(int x, int y, int z, int x1, int y1, int z1) {
        int d1 = x - x1;
        int d2 = y - y1;
        int d3 = z - z1;
        return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    private double standardDeviation(DoubleArrayList cluster) {
        double sumX = Descriptive.sum(cluster);
        double sumSqX = Descriptive.sumOfSquares(cluster);
        double variance = Descriptive.variance(cluster.size(), sumX, sumSqX);
        return Descriptive.standardDeviation(variance);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

